/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsbatch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class MetricValue
implements JsonSerializable<MetricValue> {
    private final OffsetDateTime timeStamp;
    private Double average;
    private Double minimum;
    private Double maximum;
    private Double total;
    private Double count;

    public MetricValue(OffsetDateTime timeStamp) {
        this.timeStamp = timeStamp;
    }

    public OffsetDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public Double getAverage() {
        return this.average;
    }

    public MetricValue setAverage(Double average) {
        this.average = average;
        return this;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public MetricValue setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public MetricValue setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double getTotal() {
        return this.total;
    }

    public MetricValue setTotal(Double total) {
        this.total = total;
        return this;
    }

    public Double getCount() {
        return this.count;
    }

    public MetricValue setCount(Double count) {
        this.count = count;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeStamp", this.timeStamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timeStamp));
        jsonWriter.writeNumberField("average", (Number)this.average);
        jsonWriter.writeNumberField("minimum", (Number)this.minimum);
        jsonWriter.writeNumberField("maximum", (Number)this.maximum);
        jsonWriter.writeNumberField("total", (Number)this.total);
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static MetricValue fromJson(JsonReader jsonReader) throws IOException {
        return (MetricValue)jsonReader.readObject(reader -> {
            boolean timeStampFound = false;
            OffsetDateTime timeStamp = null;
            Double average = null;
            Double minimum = null;
            Double maximum = null;
            Double total = null;
            Double count = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeStamp".equals(fieldName)) {
                    timeStamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    timeStampFound = true;
                    continue;
                }
                if ("average".equals(fieldName)) {
                    average = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    minimum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    maximum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("total".equals(fieldName)) {
                    total = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            if (timeStampFound) {
                MetricValue deserializedMetricValue = new MetricValue(timeStamp);
                deserializedMetricValue.average = average;
                deserializedMetricValue.minimum = minimum;
                deserializedMetricValue.maximum = maximum;
                deserializedMetricValue.total = total;
                deserializedMetricValue.count = count;
                return deserializedMetricValue;
            }
            throw new IllegalStateException("Missing required property: timeStamp");
        });
    }
}

