/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.logs.MetadatasImpl;
import com.azure.monitor.query.implementation.logs.QueriesImpl;

public final class AzureLogAnalyticsImpl {
    private final String host;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final QueriesImpl queries;
    private final MetadatasImpl metadatas;

    public String getHost() {
        return this.host;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public QueriesImpl getQueries() {
        return this.queries;
    }

    public MetadatasImpl getMetadatas() {
        return this.metadatas;
    }

    AzureLogAnalyticsImpl(String host) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), host);
    }

    AzureLogAnalyticsImpl(HttpPipeline httpPipeline, String host) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), host);
    }

    AzureLogAnalyticsImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String host) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.host = host;
        this.queries = new QueriesImpl(this);
        this.metadatas = new MetadatasImpl(this);
    }
}

