/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.QueryBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class BatchQueryRequest
implements JsonSerializable<BatchQueryRequest> {
    private final String id;
    private Map<String, String> headers;
    private final QueryBody body;
    private String path = "/query";
    private String method = "POST";
    private final String workspace;

    public BatchQueryRequest(String id, QueryBody body, String workspace) {
        this.id = id;
        this.body = body;
        this.workspace = workspace;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public BatchQueryRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public QueryBody getBody() {
        return this.body;
    }

    public String getPath() {
        return this.path;
    }

    public BatchQueryRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public BatchQueryRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("body", (JsonSerializable)this.body);
        jsonWriter.writeStringField("workspace", this.workspace);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("method", this.method);
        return jsonWriter.writeEndObject();
    }

    public static BatchQueryRequest fromJson(JsonReader jsonReader) throws IOException {
        return (BatchQueryRequest)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean bodyFound = false;
            QueryBody body = null;
            boolean workspaceFound = false;
            String workspace = null;
            Map headers = null;
            String path = null;
            String method = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("body".equals(fieldName)) {
                    body = QueryBody.fromJson(reader);
                    bodyFound = true;
                    continue;
                }
                if ("workspace".equals(fieldName)) {
                    workspace = reader.getString();
                    workspaceFound = true;
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    headers = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("path".equals(fieldName)) {
                    path = reader.getString();
                    continue;
                }
                if ("method".equals(fieldName)) {
                    method = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && bodyFound && workspaceFound) {
                BatchQueryRequest deserializedBatchQueryRequest = new BatchQueryRequest(id, body, workspace);
                deserializedBatchQueryRequest.headers = headers;
                deserializedBatchQueryRequest.path = path;
                deserializedBatchQueryRequest.method = method;
                return deserializedBatchQueryRequest;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!bodyFound) {
                missingProperties.add("body");
            }
            if (!workspaceFound) {
                missingProperties.add("workspace");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

