/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ErrorDetail
implements JsonSerializable<ErrorDetail> {
    private final String code;
    private final String message;
    private String target;
    private String value;
    private List<String> resources;
    private Object additionalProperties;

    public ErrorDetail(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public ErrorDetail setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ErrorDetail setValue(String value) {
        this.value = value;
        return this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public ErrorDetail setResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public Object getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ErrorDetail setAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeString(element));
        jsonWriter.writeUntypedField("additionalProperties", this.additionalProperties);
        return jsonWriter.writeEndObject();
    }

    public static ErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorDetail)jsonReader.readObject(reader -> {
            boolean codeFound = false;
            String code = null;
            boolean messageFound = false;
            String message = null;
            String target = null;
            String value = null;
            List resources = null;
            Object additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    resources = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("additionalProperties".equals(fieldName)) {
                    additionalProperties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            if (codeFound && messageFound) {
                ErrorDetail deserializedErrorDetail = new ErrorDetail(code, message);
                deserializedErrorDetail.target = target;
                deserializedErrorDetail.value = value;
                deserializedErrorDetail.resources = resources;
                deserializedErrorDetail.additionalProperties = additionalProperties;
                return deserializedErrorDetail;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!codeFound) {
                missingProperties.add("code");
            }
            if (!messageFound) {
                missingProperties.add("message");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

