/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.ErrorDetail;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ErrorInfo
implements JsonSerializable<ErrorInfo> {
    private final String code;
    private final String message;
    private List<ErrorDetail> details;
    private ErrorInfo innererror;
    private Object additionalProperties;

    public ErrorInfo(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ErrorDetail> getDetails() {
        return this.details;
    }

    public ErrorInfo setDetails(List<ErrorDetail> details) {
        this.details = details;
        return this;
    }

    public ErrorInfo getInnererror() {
        return this.innererror;
    }

    public ErrorInfo setInnererror(ErrorInfo innererror) {
        this.innererror = innererror;
        return this;
    }

    public Object getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ErrorInfo setAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innererror", (JsonSerializable)this.innererror);
        jsonWriter.writeUntypedField("additionalProperties", this.additionalProperties);
        return jsonWriter.writeEndObject();
    }

    public static ErrorInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorInfo)jsonReader.readObject(reader -> {
            boolean codeFound = false;
            String code = null;
            boolean messageFound = false;
            String message = null;
            List details = null;
            ErrorInfo innererror = null;
            Object additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ErrorDetail.fromJson(reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    innererror = ErrorInfo.fromJson(reader);
                    continue;
                }
                if ("additionalProperties".equals(fieldName)) {
                    additionalProperties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            if (codeFound && messageFound) {
                ErrorInfo deserializedErrorInfo = new ErrorInfo(code, message);
                deserializedErrorInfo.details = details;
                deserializedErrorInfo.innererror = innererror;
                deserializedErrorInfo.additionalProperties = additionalProperties;
                return deserializedErrorInfo;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!codeFound) {
                missingProperties.add("code");
            }
            if (!messageFound) {
                missingProperties.add("message");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

