/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataFunctionRelated;
import java.io.IOException;
import java.util.ArrayList;

public final class MetadataFunction
implements JsonSerializable<MetadataFunction> {
    private final String id;
    private final String name;
    private String parameters;
    private String displayName;
    private String description;
    private final String body;
    private Object tags;
    private Object properties;
    private MetadataFunctionRelated related;

    public MetadataFunction(String id, String name, String body) {
        this.id = id;
        this.name = name;
        this.body = body;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParameters() {
        return this.parameters;
    }

    public MetadataFunction setParameters(String parameters) {
        this.parameters = parameters;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetadataFunction setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataFunction setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public Object getTags() {
        return this.tags;
    }

    public MetadataFunction setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    public Object getProperties() {
        return this.properties;
    }

    public MetadataFunction setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public MetadataFunctionRelated getRelated() {
        return this.related;
    }

    public MetadataFunction setRelated(MetadataFunctionRelated related) {
        this.related = related;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("parameters", this.parameters);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("tags", this.tags);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        return jsonWriter.writeEndObject();
    }

    public static MetadataFunction fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataFunction)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean nameFound = false;
            String name = null;
            boolean bodyFound = false;
            String body = null;
            String parameters = null;
            String displayName = null;
            String description = null;
            Object tags = null;
            Object properties = null;
            MetadataFunctionRelated related = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("body".equals(fieldName)) {
                    body = reader.getString();
                    bodyFound = true;
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readUntyped();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readUntyped();
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataFunctionRelated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && nameFound && bodyFound) {
                MetadataFunction deserializedMetadataFunction = new MetadataFunction(id, name, body);
                deserializedMetadataFunction.parameters = parameters;
                deserializedMetadataFunction.displayName = displayName;
                deserializedMetadataFunction.description = description;
                deserializedMetadataFunction.tags = tags;
                deserializedMetadataFunction.properties = properties;
                deserializedMetadataFunction.related = related;
                return deserializedMetadataFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!bodyFound) {
                missingProperties.add("body");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

