/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataColumnDataType;
import java.io.IOException;
import java.util.ArrayList;

public final class MetadataTableColumnsItem
implements JsonSerializable<MetadataTableColumnsItem> {
    private final String name;
    private String description;
    private final MetadataColumnDataType type;
    private Boolean isPreferredFacet;
    private Object source;

    public MetadataTableColumnsItem(String name, MetadataColumnDataType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataTableColumnsItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public MetadataColumnDataType getType() {
        return this.type;
    }

    public Boolean isPreferredFacet() {
        return this.isPreferredFacet;
    }

    public MetadataTableColumnsItem setIsPreferredFacet(Boolean isPreferredFacet) {
        this.isPreferredFacet = isPreferredFacet;
        return this;
    }

    public Object getSource() {
        return this.source;
    }

    public MetadataTableColumnsItem setSource(Object source) {
        this.source = source;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isPreferredFacet", this.isPreferredFacet);
        jsonWriter.writeUntypedField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    public static MetadataTableColumnsItem fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataTableColumnsItem)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean typeFound = false;
            MetadataColumnDataType type = null;
            String description = null;
            Boolean isPreferredFacet = null;
            Object source = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = MetadataColumnDataType.fromString(reader.getString());
                    typeFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("isPreferredFacet".equals(fieldName)) {
                    isPreferredFacet = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    source = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && typeFound) {
                MetadataTableColumnsItem deserializedMetadataTableColumnsItem = new MetadataTableColumnsItem(name, type);
                deserializedMetadataTableColumnsItem.description = description;
                deserializedMetadataTableColumnsItem.isPreferredFacet = isPreferredFacet;
                deserializedMetadataTableColumnsItem.source = source;
                return deserializedMetadataTableColumnsItem;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!typeFound) {
                missingProperties.add("type");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

