/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metrics.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.metrics.models.LocalizableString;
import com.azure.monitor.query.implementation.metrics.models.MetricUnit;
import com.azure.monitor.query.implementation.metrics.models.TimeSeriesElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Metric
implements JsonSerializable<Metric> {
    private final String id;
    private final String type;
    private final LocalizableString name;
    private String displayDescription;
    private String errorCode;
    private String errorMessage;
    private final MetricUnit unit;
    private final List<TimeSeriesElement> timeseries;

    public Metric(String id, String type, LocalizableString name, MetricUnit unit, List<TimeSeriesElement> timeseries) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.unit = unit;
        this.timeseries = timeseries;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public LocalizableString getName() {
        return this.name;
    }

    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public Metric setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Metric setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Metric setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public List<TimeSeriesElement> getTimeseries() {
        return this.timeseries;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("timeseries", this.timeseries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    public static Metric fromJson(JsonReader jsonReader) throws IOException {
        return (Metric)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean typeFound = false;
            String type = null;
            boolean nameFound = false;
            LocalizableString name = null;
            boolean unitFound = false;
            MetricUnit unit = null;
            boolean timeseriesFound = false;
            List timeseries = null;
            String displayDescription = null;
            String errorCode = null;
            String errorMessage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    typeFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = LocalizableString.fromJson(reader);
                    nameFound = true;
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    unit = MetricUnit.fromString(reader.getString());
                    unitFound = true;
                    continue;
                }
                if ("timeseries".equals(fieldName)) {
                    timeseries = reader.readArray(reader1 -> TimeSeriesElement.fromJson(reader1));
                    timeseriesFound = true;
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    displayDescription = reader.getString();
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && typeFound && nameFound && unitFound && timeseriesFound) {
                Metric deserializedMetric = new Metric(id, type, name, unit, timeseries);
                deserializedMetric.displayDescription = displayDescription;
                deserializedMetric.errorCode = errorCode;
                deserializedMetric.errorMessage = errorMessage;
                return deserializedMetric;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!typeFound) {
                missingProperties.add("type");
            }
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!unitFound) {
                missingProperties.add("unit");
            }
            if (!timeseriesFound) {
                missingProperties.add("timeseries");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

