/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metrics.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.metrics.models.Metric;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class MetricsResponse
implements JsonSerializable<MetricsResponse> {
    private Integer cost;
    private final String timespan;
    private Duration interval;
    private String namespace;
    private String resourceregion;
    private final List<Metric> value;

    public MetricsResponse(String timespan, List<Metric> value) {
        this.timespan = timespan;
        this.value = value;
    }

    public Integer getCost() {
        return this.cost;
    }

    public MetricsResponse setCost(Integer cost) {
        this.cost = cost;
        return this;
    }

    public String getTimespan() {
        return this.timespan;
    }

    public Duration getInterval() {
        return this.interval;
    }

    public MetricsResponse setInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MetricsResponse setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getResourceregion() {
        return this.resourceregion;
    }

    public MetricsResponse setResourceregion(String resourceregion) {
        this.resourceregion = resourceregion;
        return this;
    }

    public List<Metric> getValue() {
        return this.value;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("cost", (Number)this.cost);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays((Duration)this.interval));
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("resourceregion", this.resourceregion);
        return jsonWriter.writeEndObject();
    }

    public static MetricsResponse fromJson(JsonReader jsonReader) throws IOException {
        return (MetricsResponse)jsonReader.readObject(reader -> {
            boolean timespanFound = false;
            String timespan = null;
            boolean valueFound = false;
            List value = null;
            Integer cost = null;
            Duration interval = null;
            String namespace = null;
            String resourceregion = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timespan".equals(fieldName)) {
                    timespan = reader.getString();
                    timespanFound = true;
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.readArray(reader1 -> Metric.fromJson(reader1));
                    valueFound = true;
                    continue;
                }
                if ("cost".equals(fieldName)) {
                    cost = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    interval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    namespace = reader.getString();
                    continue;
                }
                if ("resourceregion".equals(fieldName)) {
                    resourceregion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (timespanFound && valueFound) {
                MetricsResponse deserializedMetricsResponse = new MetricsResponse(timespan, value);
                deserializedMetricsResponse.cost = cost;
                deserializedMetricsResponse.interval = interval;
                deserializedMetricsResponse.namespace = namespace;
                deserializedMetricsResponse.resourceregion = resourceregion;
                return deserializedMetricsResponse;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!timespanFound) {
                missingProperties.add("timespan");
            }
            if (!valueFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

