/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsbatch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.metricsbatch.models.Metric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MetricResultsResponseValuesItem
implements JsonSerializable<MetricResultsResponseValuesItem> {
    private final String starttime;
    private final String endtime;
    private String interval;
    private String namespace;
    private String resourceregion;
    private String resourceid;
    private final List<Metric> value;

    public MetricResultsResponseValuesItem(String starttime, String endtime, List<Metric> value) {
        this.starttime = starttime;
        this.endtime = endtime;
        this.value = value;
    }

    public String getStarttime() {
        return this.starttime;
    }

    public String getEndtime() {
        return this.endtime;
    }

    public String getInterval() {
        return this.interval;
    }

    public MetricResultsResponseValuesItem setInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MetricResultsResponseValuesItem setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getResourceregion() {
        return this.resourceregion;
    }

    public MetricResultsResponseValuesItem setResourceregion(String resourceregion) {
        this.resourceregion = resourceregion;
        return this;
    }

    public String getResourceid() {
        return this.resourceid;
    }

    public MetricResultsResponseValuesItem setResourceid(String resourceid) {
        this.resourceid = resourceid;
        return this;
    }

    public List<Metric> getValue() {
        return this.value;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("starttime", this.starttime);
        jsonWriter.writeStringField("endtime", this.endtime);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("interval", this.interval);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("resourceregion", this.resourceregion);
        jsonWriter.writeStringField("resourceid", this.resourceid);
        return jsonWriter.writeEndObject();
    }

    public static MetricResultsResponseValuesItem fromJson(JsonReader jsonReader) throws IOException {
        return (MetricResultsResponseValuesItem)jsonReader.readObject(reader -> {
            boolean starttimeFound = false;
            String starttime = null;
            boolean endtimeFound = false;
            String endtime = null;
            boolean valueFound = false;
            List value = null;
            String interval = null;
            String namespace = null;
            String resourceregion = null;
            String resourceid = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("starttime".equals(fieldName)) {
                    starttime = reader.getString();
                    starttimeFound = true;
                    continue;
                }
                if ("endtime".equals(fieldName)) {
                    endtime = reader.getString();
                    endtimeFound = true;
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.readArray(reader1 -> Metric.fromJson(reader1));
                    valueFound = true;
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    interval = reader.getString();
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    namespace = reader.getString();
                    continue;
                }
                if ("resourceregion".equals(fieldName)) {
                    resourceregion = reader.getString();
                    continue;
                }
                if ("resourceid".equals(fieldName)) {
                    resourceid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (starttimeFound && endtimeFound && valueFound) {
                MetricResultsResponseValuesItem deserializedMetricResultsResponseValuesItem = new MetricResultsResponseValuesItem(starttime, endtime, value);
                deserializedMetricResultsResponseValuesItem.interval = interval;
                deserializedMetricResultsResponseValuesItem.namespace = namespace;
                deserializedMetricResultsResponseValuesItem.resourceregion = resourceregion;
                deserializedMetricResultsResponseValuesItem.resourceid = resourceid;
                return deserializedMetricResultsResponseValuesItem;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!starttimeFound) {
                missingProperties.add("starttime");
            }
            if (!endtimeFound) {
                missingProperties.add("endtime");
            }
            if (!valueFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

