/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsnamespaces.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.metricsnamespaces.models.MetricNamespaceName;
import com.azure.monitor.query.implementation.metricsnamespaces.models.NamespaceClassification;
import java.io.IOException;

public final class MetricNamespace
implements JsonSerializable<MetricNamespace> {
    private String id;
    private String type;
    private String name;
    private NamespaceClassification classification;
    private MetricNamespaceName properties;

    public String getId() {
        return this.id;
    }

    public MetricNamespace setId(String id) {
        this.id = id;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public MetricNamespace setType(String type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MetricNamespace setName(String name) {
        this.name = name;
        return this;
    }

    public NamespaceClassification getClassification() {
        return this.classification;
    }

    public MetricNamespace setClassification(NamespaceClassification classification) {
        this.classification = classification;
        return this;
    }

    public MetricNamespaceName getProperties() {
        return this.properties;
    }

    public MetricNamespace setProperties(MetricNamespaceName properties) {
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("classification", this.classification == null ? null : this.classification.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static MetricNamespace fromJson(JsonReader jsonReader) throws IOException {
        return (MetricNamespace)jsonReader.readObject(reader -> {
            MetricNamespace deserializedMetricNamespace = new MetricNamespace();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMetricNamespace.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMetricNamespace.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricNamespace.name = reader.getString();
                    continue;
                }
                if ("classification".equals(fieldName)) {
                    deserializedMetricNamespace.classification = NamespaceClassification.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMetricNamespace.properties = MetricNamespaceName.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricNamespace;
        });
    }
}

