/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.indexes.models.IndexDocumentsBatch;
import com.azure.search.documents.models.AutocompleteOptions;
import com.azure.search.documents.models.IndexDocumentsOptions;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.SearchOptions;
import com.azure.search.documents.models.SuggestOptions;
import com.azure.search.documents.util.AutocompletePagedIterable;
import com.azure.search.documents.util.SearchPagedIterable;
import com.azure.search.documents.util.SuggestPagedIterable;
import java.util.List;

@ServiceClient(builder=SearchClientBuilder.class)
public final class SearchClient {
    private final SearchAsyncClient asyncClient;

    SearchClient(SearchAsyncClient searchAsyncClient) {
        this.asyncClient = searchAsyncClient;
    }

    public String getIndexName() {
        return this.asyncClient.getIndexName();
    }

    HttpPipeline getHttpPipeline() {
        return this.asyncClient.getHttpPipeline();
    }

    public String getEndpoint() {
        return this.asyncClient.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult uploadDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.uploadDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.uploadDocumentsWithResponse(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult mergeDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.mergeDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.mergeDocumentsWithResponse(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult mergeOrUploadDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.mergeOrUploadDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.mergeOrUploadDocumentsWithResponse(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult deleteDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.deleteDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.deleteDocumentsWithResponse(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult indexDocuments(IndexDocumentsBatch<?> batch) {
        return (IndexDocumentsResult)this.indexDocumentsWithResponse(batch, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options, Context context) {
        return (Response)this.asyncClient.indexDocumentsWithResponse(batch, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> T getDocument(String key, Class<T> modelClass) {
        return (T)this.getDocumentWithResponse(key, modelClass, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Response<T> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields, Context context) {
        return (Response)this.asyncClient.getDocumentWithResponse(key, modelClass, selectedFields, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public long getDocumentCount() {
        return (Long)this.getDocumentCountWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Long> getDocumentCountWithResponse(Context context) {
        return (Response)this.asyncClient.getDocumentCountWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedIterable search(String searchText) {
        return this.search(searchText, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedIterable search(String searchText, SearchOptions searchOptions, Context context) {
        return new SearchPagedIterable(this.asyncClient.search(searchText, searchOptions, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SuggestPagedIterable suggest(String searchText, String suggesterName) {
        return this.suggest(searchText, suggesterName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SuggestPagedIterable suggest(String searchText, String suggesterName, SuggestOptions suggestOptions, Context context) {
        return new SuggestPagedIterable(this.asyncClient.suggest(searchText, suggesterName, suggestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public AutocompletePagedIterable autocomplete(String searchText, String suggesterName) {
        return this.autocomplete(searchText, suggesterName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public AutocompletePagedIterable autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions, Context context) {
        return new AutocompletePagedIterable(this.asyncClient.autocomplete(searchText, suggesterName, autocompleteOptions, context));
    }
}

