/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.batching.SearchIndexingPublisher;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.models.IndexActionType;
import com.azure.search.documents.options.OnActionAddedOptions;
import com.azure.search.documents.options.OnActionErrorOptions;
import com.azure.search.documents.options.OnActionSentOptions;
import com.azure.search.documents.options.OnActionSucceededOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SearchClientBuilder.class, isAsync=true)
public final class SearchIndexingBufferedAsyncSender<T> {
    private final ClientLogger logger = new ClientLogger(SearchIndexingBufferedAsyncSender.class);
    private final boolean autoFlush;
    private final long flushWindowMillis;
    final SearchIndexingPublisher<T> publisher;
    private Timer autoFlushTimer;
    private final AtomicReference<TimerTask> flushTask = new AtomicReference();
    private volatile boolean isClosed = false;

    SearchIndexingBufferedAsyncSender(SearchIndexClientImpl restClient, JsonSerializer serializer, Function<T, String> documentKeyRetriever, boolean autoFlush, Duration autoFlushInterval, int initialBatchActionCount, int maxRetriesPerAction, Duration throttlingDelay, Duration maxThrottlingDelay, Consumer<OnActionAddedOptions<T>> onActionAddedConsumer, Consumer<OnActionSucceededOptions<T>> onActionSucceededConsumer, Consumer<OnActionErrorOptions<T>> onActionErrorConsumer, Consumer<OnActionSentOptions<T>> onActionSentConsumer) {
        this.publisher = new SearchIndexingPublisher<T>(restClient, serializer, documentKeyRetriever, autoFlush, initialBatchActionCount, maxRetriesPerAction, throttlingDelay, maxThrottlingDelay, onActionAddedConsumer, onActionSucceededConsumer, onActionErrorConsumer, onActionSentConsumer);
        this.autoFlush = autoFlush;
        this.flushWindowMillis = Math.max(0L, autoFlushInterval.toMillis());
        this.autoFlushTimer = this.autoFlush && this.flushWindowMillis > 0L ? new Timer() : null;
    }

    public Collection<IndexAction<T>> getActions() {
        return this.publisher.getActions();
    }

    int getBatchActionCount() {
        return this.publisher.getBatchActionCount();
    }

    public Mono<Void> addUploadActions(Collection<T> documents) {
        return FluxUtil.withContext(context -> this.createAndAddActions(documents, IndexActionType.UPLOAD, (Context)context));
    }

    public Mono<Void> addDeleteActions(Collection<T> documents) {
        return FluxUtil.withContext(context -> this.createAndAddActions(documents, IndexActionType.DELETE, (Context)context));
    }

    public Mono<Void> addMergeActions(Collection<T> documents) {
        return FluxUtil.withContext(context -> this.createAndAddActions(documents, IndexActionType.MERGE, (Context)context));
    }

    public Mono<Void> addMergeOrUploadActions(Collection<T> documents) {
        return FluxUtil.withContext(context -> this.createAndAddActions(documents, IndexActionType.MERGE_OR_UPLOAD, (Context)context));
    }

    public Mono<Void> addActions(Collection<IndexAction<T>> actions) {
        return FluxUtil.withContext(context -> this.addActions(actions, (Context)context));
    }

    Mono<Void> createAndAddActions(Collection<T> documents, IndexActionType actionType, Context context) {
        return this.addActions(SearchIndexingBufferedAsyncSender.createDocumentActions(documents, actionType), context);
    }

    Mono<Void> addActions(Collection<IndexAction<T>> actions, Context context) {
        this.ensureOpen();
        return this.publisher.addActions(actions, context, this::rescheduleFlushTask);
    }

    public Mono<Void> flush() {
        return FluxUtil.withContext(this::flush);
    }

    Mono<Void> flush(Context context) {
        this.ensureOpen();
        this.rescheduleFlushTask();
        return this.publisher.flush(false, false, context);
    }

    private void rescheduleFlushTask() {
        if (!this.autoFlush) {
            return;
        }
        TimerTask newTask = new TimerTask(){

            @Override
            public void run() {
                Mono.defer(() -> SearchIndexingBufferedAsyncSender.this.publisher.flush(false, false, Context.NONE)).subscribe();
            }
        };
        TimerTask previousTask = this.flushTask.getAndSet(newTask);
        if (previousTask != null) {
            previousTask.cancel();
        }
        this.autoFlushTimer.schedule(newTask, this.flushWindowMillis);
    }

    public Mono<Void> close() {
        return FluxUtil.withContext(this::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mono<Void> close(Context context) {
        if (!this.isClosed) {
            SearchIndexingBufferedAsyncSender searchIndexingBufferedAsyncSender = this;
            synchronized (searchIndexingBufferedAsyncSender) {
                if (!this.isClosed) {
                    this.isClosed = true;
                    if (this.autoFlush) {
                        TimerTask currentTask = this.flushTask.getAndSet(null);
                        if (currentTask != null) {
                            currentTask.cancel();
                        }
                        this.autoFlushTimer.purge();
                        this.autoFlushTimer.cancel();
                        this.autoFlushTimer = null;
                    }
                    return this.publisher.flush(true, true, context);
                }
                return Mono.empty();
            }
        }
        return Mono.empty();
    }

    private synchronized void ensureOpen() {
        if (this.isClosed) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Buffered sender has been closed."));
        }
    }

    private static <T> Collection<IndexAction<T>> createDocumentActions(Collection<T> documents, IndexActionType actionType) {
        return documents.stream().map(document -> new IndexAction().setActionType(actionType).setDocument(document)).collect(Collectors.toList());
    }
}

