/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.search.documents.implementation.converters.IndexActionHelper;
import com.azure.search.documents.implementation.models.IndexAction;
import com.azure.search.documents.implementation.util.Utility;
import java.io.IOException;
import java.util.Map;

public final class IndexActionConverter {
    private static final ClientLogger LOGGER = new ClientLogger(IndexActionConverter.class);

    public static <T> com.azure.search.documents.models.IndexAction<T> map(IndexAction obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.models.IndexAction indexAction = new com.azure.search.documents.models.IndexAction();
        indexAction.setActionType(obj.getActionType());
        if (obj.getAdditionalProperties() != null) {
            Map<String, Object> properties = obj.getAdditionalProperties();
            IndexActionHelper.setProperties(indexAction, properties);
        }
        return indexAction;
    }

    public static <T> IndexAction map(com.azure.search.documents.models.IndexAction<T> obj, ObjectSerializer serializer) {
        if (obj == null) {
            return null;
        }
        IndexAction indexAction = new IndexAction().setActionType(obj.getActionType());
        Map mapProperties = IndexActionHelper.getProperties(obj);
        if (mapProperties == null) {
            T properties = obj.getDocument();
            if (serializer == null) {
                try {
                    String serializedJson = Utility.getDefaultSerializerAdapter().serialize(properties, SerializerEncoding.JSON);
                    mapProperties = (Map)Utility.getDefaultSerializerAdapter().deserialize(serializedJson, Utility.MAP_STRING_OBJECT_TYPE_REFERENCE.getJavaType(), SerializerEncoding.JSON);
                }
                catch (IOException ex) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("Failed to serialize IndexAction.", ex));
                }
            } else {
                mapProperties = (Map)serializer.deserializeFromBytes(serializer.serializeToBytes(properties), Utility.MAP_STRING_OBJECT_TYPE_REFERENCE);
            }
        }
        indexAction.setAdditionalProperties(mapProperties);
        return indexAction;
    }

    private IndexActionConverter() {
    }
}

