/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.search.documents.implementation.models.SearchErrorException;

public final class DocumentResponseConversions {
    private static final String DOCUMENT_NOT_FOUND = "Document not found.";

    public static Throwable exceptionMapper(Throwable throwable) {
        if (!(throwable instanceof SearchErrorException)) {
            return throwable;
        }
        SearchErrorException exception = (SearchErrorException)((Object)throwable);
        if (exception.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(DOCUMENT_NOT_FOUND, exception.getResponse());
        }
        return new HttpResponseException(exception.getMessage(), exception.getResponse());
    }

    private DocumentResponseConversions() {
    }
}

