/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;

final class Iso8601DateDeserializer
extends UntypedObjectDeserializer {
    private static final long serialVersionUID = 1L;
    private final UntypedObjectDeserializer defaultDeserializer;
    private static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    Iso8601DateDeserializer(UntypedObjectDeserializer defaultDeserializer) {
        super(null, null);
        this.defaultDeserializer = defaultDeserializer;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object obj = this.defaultDeserializer.deserialize(jp, ctxt);
        if (jp.currentTokenId() == 1) {
            return this.parseDateType(obj);
        }
        if (jp.currentTokenId() == 3) {
            List list = (List)obj;
            return list.stream().map(this::parseDateType).collect(Collectors.toList());
        }
        return obj;
    }

    private Object parseDateType(Object obj) {
        try {
            return new SimpleDateFormat(ISO8601_FORMAT).parse((String)obj);
        }
        catch (ParseException e) {
            return obj;
        }
    }
}

