/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

final class Iso8601DateSerializer
extends JsonSerializer<Date> {
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(Date.class, (JsonSerializer)new Iso8601DateSerializer());

    Iso8601DateSerializer() {
    }

    static SimpleModule getModule() {
        return MODULE;
    }

    public void serialize(Date dateValue, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String dateString = dateValue.toInstant().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        gen.writeString(dateString);
    }
}

