/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.AnalyzeRequest;
import com.azure.search.documents.indexes.implementation.models.AnalyzeResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.implementation.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class IndexesImpl {
    private final IndexesService service;
    private final SearchServiceClientImpl client;

    IndexesImpl(SearchServiceClientImpl client) {
        this.service = (IndexesService)RestProxy.create(IndexesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createWithResponseAsync(SearchIndex index, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", index, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SearchIndex>> listSinglePageAsync(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListIndexesResult)res.getValue()).getIndexes(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createOrUpdateWithResponseAsync(String indexName, SearchIndex index, Boolean allowIndexDowntime, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), indexName, allowIndexDowntime, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", index, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String indexName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), indexName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> getWithResponseAsync(String indexName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexStatistics>> getStatisticsWithResponseAsync(String indexName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getStatistics(this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResult>> analyzeWithResponseAsync(String indexName, AnalyzeRequest request, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.analyze(this.client.getEndpoint(), indexName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", request, context);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientI")
    public static interface IndexesService {
        @Post(value="/indexes")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndex>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndex var5, Context var6);

        @Get(value="/indexes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<ListIndexesResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/indexes('{indexName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndex>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="indexName") String var2, @QueryParam(value="allowIndexDowntime") Boolean var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @HeaderParam(value="Prefer") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") SearchIndex var10, Context var11);

        @Delete(value="/indexes('{indexName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/indexes('{indexName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndex>> get(@HostParam(value="endpoint") String var1, @PathParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/indexes('{indexName}')/search.stats")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchIndexStatistics>> getStatistics(@HostParam(value="endpoint") String var1, @PathParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/indexes('{indexName}')/search.analyze")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<AnalyzeResult>> analyze(@HostParam(value="endpoint") String var1, @PathParam(value="indexName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") AnalyzeRequest var6, Context var7);
    }
}

