/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.DataSourcesImpl;
import com.azure.search.documents.indexes.implementation.IndexersImpl;
import com.azure.search.documents.indexes.implementation.IndexesImpl;
import com.azure.search.documents.indexes.implementation.SkillsetsImpl;
import com.azure.search.documents.indexes.implementation.SynonymMapsImpl;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SearchServiceClientImpl {
    private final SearchServiceClientService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final DataSourcesImpl dataSources;
    private final IndexersImpl indexers;
    private final SkillsetsImpl skillsets;
    private final SynonymMapsImpl synonymMaps;
    private final IndexesImpl indexes;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DataSourcesImpl getDataSources() {
        return this.dataSources;
    }

    public IndexersImpl getIndexers() {
        return this.indexers;
    }

    public SkillsetsImpl getSkillsets() {
        return this.skillsets;
    }

    public SynonymMapsImpl getSynonymMaps() {
        return this.synonymMaps;
    }

    public IndexesImpl getIndexes() {
        return this.indexes;
    }

    public SearchServiceClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    public SearchServiceClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    public SearchServiceClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.dataSources = new DataSourcesImpl(this);
        this.indexers = new IndexersImpl(this);
        this.skillsets = new SkillsetsImpl(this);
        this.synonymMaps = new SynonymMapsImpl(this);
        this.indexes = new IndexesImpl(this);
        this.service = (SearchServiceClientService)RestProxy.create(SearchServiceClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchServiceStatistics>> getServiceStatisticsWithResponseAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getServiceStatistics(this.getEndpoint(), xMsClientRequestId, this.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClient")
    public static interface SearchServiceClientService {
        @Get(value="/servicestats")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SearchServiceStatistics>> getServiceStatistics(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

