/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.indexes.models.EntityCategory;
import com.azure.search.documents.indexes.models.EntityRecognitionSkillLanguage;
import com.azure.search.documents.indexes.models.EntityRecognitionSkillVersion;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Skills.Text.EntityRecognitionSkill")
public final class EntityRecognitionSkill
extends SearchIndexerSkill {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EntityRecognitionSkill.class);
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private EntityRecognitionSkillVersion version;
    @JsonProperty(value="categories")
    private List<EntityCategory> categories;
    @JsonProperty(value="defaultLanguageCode")
    private EntityRecognitionSkillLanguage defaultLanguageCode;
    @JsonProperty(value="includeTypelessEntities")
    private Boolean includeTypelessEntities;
    @JsonProperty(value="minimumPrecision")
    private Double minimumPrecision;
    @JsonProperty(value="modelVersion")
    private String modelVersion;

    @JsonCreator
    public EntityRecognitionSkill(@JsonProperty(value="inputs", required=true) List<InputFieldMappingEntry> inputs, @JsonProperty(value="outputs", required=true) List<OutputFieldMappingEntry> outputs) {
        this(inputs, outputs, EntityRecognitionSkillVersion.V1);
    }

    public EntityRecognitionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, EntityRecognitionSkillVersion version) {
        super(inputs, outputs);
        this.version = version;
    }

    public EntityRecognitionSkillVersion getSkillVersion() {
        return this.version;
    }

    public List<EntityCategory> getCategories() {
        return this.categories;
    }

    @JsonSetter
    public EntityRecognitionSkill setCategories(List<EntityCategory> categories) {
        this.categories = categories;
        return this;
    }

    public EntityRecognitionSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public EntityRecognitionSkill setDefaultLanguageCode(EntityRecognitionSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Boolean areTypelessEntitiesIncluded() {
        return this.includeTypelessEntities;
    }

    public EntityRecognitionSkill setTypelessEntitiesIncluded(Boolean includeTypelessEntities) {
        if (includeTypelessEntities != null && this.version == EntityRecognitionSkillVersion.V3) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("EntityRecognitionSkill using V3 doesn't support 'includeTypelessEntities'."));
        }
        this.includeTypelessEntities = includeTypelessEntities;
        return this;
    }

    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    public EntityRecognitionSkill setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public EntityRecognitionSkill setModelVersion(String modelVersion) {
        if (modelVersion != null && this.version == EntityRecognitionSkillVersion.V1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("EntityRecognitionSkill using V1 doesn't support 'modelVersion'."));
        }
        this.modelVersion = modelVersion;
        return this;
    }

    public EntityRecognitionSkill setCategories(EntityCategory ... categories) {
        this.categories = categories == null ? null : Arrays.asList(categories);
        return this;
    }
}

