/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.search.documents.indexes.models.BlobIndexerDataToExtract;
import com.azure.search.documents.indexes.models.BlobIndexerImageAction;
import com.azure.search.documents.indexes.models.BlobIndexerParsingMode;
import com.azure.search.documents.indexes.models.BlobIndexerPdfTextRotationAlgorithm;
import com.azure.search.documents.indexes.models.IndexerExecutionEnvironment;
import com.azure.search.documents.indexes.models.IndexingParametersConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public final class IndexingParameters {
    @JsonProperty(value="batchSize")
    private Integer batchSize;
    @JsonProperty(value="maxFailedItems")
    private Integer maxFailedItems;
    @JsonProperty(value="maxFailedItemsPerBatch")
    private Integer maxFailedItemsPerBatch;
    @JsonProperty(value="configuration")
    private Map<String, Object> configuration;

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public IndexingParameters setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getMaxFailedItems() {
        return this.maxFailedItems;
    }

    public IndexingParameters setMaxFailedItems(Integer maxFailedItems) {
        this.maxFailedItems = maxFailedItems;
        return this;
    }

    public Integer getMaxFailedItemsPerBatch() {
        return this.maxFailedItemsPerBatch;
    }

    public IndexingParameters setMaxFailedItemsPerBatch(Integer maxFailedItemsPerBatch) {
        this.maxFailedItemsPerBatch = maxFailedItemsPerBatch;
        return this;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public IndexingParameters setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
        return this;
    }

    public IndexingParametersConfiguration getIndexingParametersConfiguration() {
        if (CoreUtils.isNullOrEmpty(this.configuration)) {
            return null;
        }
        IndexingParametersConfiguration configuration = new IndexingParametersConfiguration();
        block36: for (Map.Entry<String, Object> kvp : this.configuration.entrySet()) {
            String key = kvp.getKey();
            if (key == null) continue;
            String value = kvp.getValue() == null ? null : String.valueOf(kvp.getValue());
            switch (key) {
                case "parsingMode": {
                    configuration.setParsingMode(BlobIndexerParsingMode.fromString(value));
                    continue block36;
                }
                case "excludedFileNameExtensions": {
                    configuration.setExcludedFileNameExtensions(value);
                    continue block36;
                }
                case "indexedFileNameExtensions": {
                    configuration.setIndexedFileNameExtensions(value);
                    continue block36;
                }
                case "failOnUnsupportedContentType": {
                    configuration.setFailOnUnsupportedContentType(Boolean.valueOf(value));
                    continue block36;
                }
                case "failOnUnprocessableDocument": {
                    configuration.setFailOnUnprocessableDocument(Boolean.valueOf(value));
                    continue block36;
                }
                case "indexStorageMetadataOnlyForOversizedDocuments": {
                    configuration.setIndexStorageMetadataOnlyForOversizedDocuments(Boolean.valueOf(value));
                    continue block36;
                }
                case "delimitedTextHeaders": {
                    configuration.setDelimitedTextHeaders(value);
                    continue block36;
                }
                case "delimitedTextDelimiter": {
                    configuration.setDelimitedTextDelimiter(value);
                    continue block36;
                }
                case "firstLineContainsHeaders": {
                    configuration.setFirstLineContainsHeaders(Boolean.valueOf(value));
                    continue block36;
                }
                case "documentRoot": {
                    configuration.setDocumentRoot(value);
                    continue block36;
                }
                case "dataToExtract": {
                    configuration.setDataToExtract(BlobIndexerDataToExtract.fromString(value));
                    continue block36;
                }
                case "imageAction": {
                    configuration.setImageAction(BlobIndexerImageAction.fromString(value));
                    continue block36;
                }
                case "allowSkillsetToReadFileData": {
                    configuration.setAllowSkillsetToReadFileData(Boolean.valueOf(value));
                    continue block36;
                }
                case "pdfTextRotationAlgorithm": {
                    configuration.setPdfTextRotationAlgorithm(BlobIndexerPdfTextRotationAlgorithm.fromString(value));
                    continue block36;
                }
                case "executionEnvironment": {
                    configuration.setExecutionEnvironment(IndexerExecutionEnvironment.fromString(value));
                    continue block36;
                }
                case "queryTimeout": {
                    configuration.setQueryTimeout(value);
                    continue block36;
                }
            }
            configuration.setAdditionalProperties(key, value);
        }
        return configuration;
    }

    public IndexingParameters setIndexingParametersConfiguration(IndexingParametersConfiguration configuration) {
        this.setConfigurationValue((Object)configuration.getParsingMode(), "parsingMode");
        this.setConfigurationValue(configuration.getExcludedFileNameExtensions(), "excludedFileNameExtensions");
        this.setConfigurationValue(configuration.getIndexedFileNameExtensions(), "indexedFileNameExtensions");
        this.setConfigurationValue(configuration.isFailOnUnsupportedContentType(), "failOnUnsupportedContentType");
        this.setConfigurationValue(configuration.isFailOnUnprocessableDocument(), "failOnUnprocessableDocument");
        this.setConfigurationValue(configuration.isIndexStorageMetadataOnlyForOversizedDocuments(), "indexStorageMetadataOnlyForOversizedDocuments");
        this.setConfigurationValue(configuration.getDelimitedTextHeaders(), "delimitedTextHeaders");
        this.setConfigurationValue(configuration.getDelimitedTextDelimiter(), "delimitedTextDelimiter");
        this.setConfigurationValue(configuration.isFirstLineContainsHeaders(), "firstLineContainsHeaders");
        this.setConfigurationValue(configuration.getDocumentRoot(), "documentRoot");
        this.setConfigurationValue((Object)configuration.getDataToExtract(), "dataToExtract");
        this.setConfigurationValue((Object)configuration.getImageAction(), "imageAction");
        this.setConfigurationValue(configuration.isAllowSkillsetToReadFileData(), "allowSkillsetToReadFileData");
        this.setConfigurationValue((Object)configuration.getPdfTextRotationAlgorithm(), "pdfTextRotationAlgorithm");
        this.setConfigurationValue((Object)configuration.getExecutionEnvironment(), "executionEnvironment");
        this.setConfigurationValue(configuration.getQueryTimeout(), "queryTimeout");
        Map<String, Object> additionalProperties = configuration.getAdditionalProperties();
        if (!CoreUtils.isNullOrEmpty(additionalProperties)) {
            this.configuration.putAll(additionalProperties);
        }
        return this;
    }

    private void setConfigurationValue(Object value, String key) {
        if (value == null) {
            return;
        }
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.put(key, String.valueOf(value));
    }
}

