/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.RegexFlags;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Azure.Search.PatternAnalyzer")
public final class PatternAnalyzer
extends LexicalAnalyzer {
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Azure.Search.PatternAnalyzer";
    @JsonProperty(value="lowercase")
    private Boolean lowerCaseTerms;
    @JsonProperty(value="pattern")
    private String pattern;
    @JsonProperty(value="flags")
    private RegexFlags flags;
    @JsonProperty(value="stopwords")
    private List<String> stopwords;

    @JsonCreator
    public PatternAnalyzer(@JsonProperty(value="name", required=true) String name) {
        super(name);
    }

    public Boolean areLowerCaseTerms() {
        return this.lowerCaseTerms;
    }

    public PatternAnalyzer setLowerCaseTerms(Boolean lowerCaseTerms) {
        this.lowerCaseTerms = lowerCaseTerms;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PatternAnalyzer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        }
        String[] flagStrings = this.flags.toString().split("\\|");
        return Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
    }

    @JsonSetter
    public PatternAnalyzer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(ExpandableStringEnum::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    @JsonSetter
    public PatternAnalyzer setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    public PatternAnalyzer setStopwords(String ... stopwords) {
        this.stopwords = stopwords == null ? null : Arrays.asList(stopwords);
        return this;
    }

    public PatternAnalyzer setFlags(RegexFlags ... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        }
        return this.setFlags(Arrays.asList(flags));
    }
}

