/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.PiiDetectionSkillMaskingMode;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Skills.Text.PIIDetectionSkill")
public final class PiiDetectionSkill
extends SearchIndexerSkill {
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Skills.Text.PIIDetectionSkill";
    @JsonProperty(value="defaultLanguageCode")
    private String defaultLanguageCode;
    @JsonProperty(value="minimumPrecision")
    private Double minimumPrecision;
    @JsonProperty(value="maskingMode")
    private PiiDetectionSkillMaskingMode maskingMode;
    @JsonProperty(value="maskingCharacter")
    private String maskingCharacter;
    @JsonProperty(value="modelVersion")
    private String modelVersion;
    @JsonProperty(value="piiCategories")
    private List<String> piiCategories;
    @JsonProperty(value="domain")
    private String domain;

    @JsonCreator
    public PiiDetectionSkill(@JsonProperty(value="inputs", required=true) List<InputFieldMappingEntry> inputs, @JsonProperty(value="outputs", required=true) List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public PiiDetectionSkill setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    public PiiDetectionSkill setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    public PiiDetectionSkillMaskingMode getMaskingMode() {
        return this.maskingMode;
    }

    public PiiDetectionSkill setMaskingMode(PiiDetectionSkillMaskingMode maskingMode) {
        this.maskingMode = maskingMode;
        return this;
    }

    public String getMaskingCharacter() {
        return this.maskingCharacter;
    }

    public PiiDetectionSkill setMaskingCharacter(String maskingCharacter) {
        this.maskingCharacter = maskingCharacter;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public PiiDetectionSkill setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    public List<String> getPiiCategories() {
        return this.piiCategories;
    }

    public PiiDetectionSkill setPiiCategories(List<String> piiCategories) {
        this.piiCategories = piiCategories;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public PiiDetectionSkill setDomain(String domain) {
        this.domain = domain;
        return this;
    }
}

