/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionAggregation;
import com.azure.search.documents.indexes.models.TextWeights;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Arrays;
import java.util.List;

public final class ScoringProfile {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="text")
    private TextWeights textWeights;
    @JsonProperty(value="functions")
    private List<ScoringFunction> functions;
    @JsonProperty(value="functionAggregation")
    private ScoringFunctionAggregation functionAggregation;

    @JsonCreator
    public ScoringProfile(@JsonProperty(value="name", required=true) String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TextWeights getTextWeights() {
        return this.textWeights;
    }

    public ScoringProfile setTextWeights(TextWeights textWeights) {
        this.textWeights = textWeights;
        return this;
    }

    public List<ScoringFunction> getFunctions() {
        return this.functions;
    }

    @JsonSetter
    public ScoringProfile setFunctions(List<ScoringFunction> functions) {
        this.functions = functions;
        return this;
    }

    public ScoringFunctionAggregation getFunctionAggregation() {
        return this.functionAggregation;
    }

    public ScoringProfile setFunctionAggregation(ScoringFunctionAggregation functionAggregation) {
        this.functionAggregation = functionAggregation;
        return this;
    }

    public ScoringProfile setFunctions(ScoringFunction ... functions) {
        this.functions = functions == null ? null : Arrays.asList(functions);
        return this;
    }
}

