/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.SentimentSkillLanguage;
import com.azure.search.documents.indexes.models.SentimentSkillVersion;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Skills.Text.SentimentSkill")
public final class SentimentSkill
extends SearchIndexerSkill {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SentimentSkill.class);
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private SentimentSkillVersion version;
    @JsonProperty(value="defaultLanguageCode")
    private SentimentSkillLanguage defaultLanguageCode;
    @JsonProperty(value="includeOpinionMining")
    private Boolean includeOpinionMining;
    @JsonProperty(value="modelVersion")
    private String modelVersion;

    @JsonCreator
    public SentimentSkill(@JsonProperty(value="inputs", required=true) List<InputFieldMappingEntry> inputs, @JsonProperty(value="outputs", required=true) List<OutputFieldMappingEntry> outputs) {
        this(inputs, outputs, SentimentSkillVersion.V1);
    }

    public SentimentSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, SentimentSkillVersion version) {
        super(inputs, outputs);
        this.version = version;
    }

    public SentimentSkillVersion getSkillVersion() {
        return this.version;
    }

    public SentimentSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public SentimentSkill setDefaultLanguageCode(SentimentSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Boolean isIncludeOpinionMining() {
        return this.includeOpinionMining;
    }

    public SentimentSkill setIncludeOpinionMining(Boolean includeOpinionMining) {
        if (includeOpinionMining != null && this.version == SentimentSkillVersion.V1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("SentimentSkill using V1 doesn't support 'includeOpinionMining'."));
        }
        this.includeOpinionMining = includeOpinionMining;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public SentimentSkill setModelVersion(String modelVersion) {
        if (modelVersion != null && this.version == SentimentSkillVersion.V1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("SentimentSkill using V1 doesn't support 'modelVersion'."));
        }
        this.modelVersion = modelVersion;
        return this;
    }
}

