/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.search.documents.implementation.converters.IndexActionHelper;
import com.azure.search.documents.models.IndexActionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Map;

public final class IndexAction<T> {
    @JsonUnwrapped
    private T document;
    @JsonIgnore
    private Map<String, Object> properties;
    @JsonProperty(value="@search.action")
    private IndexActionType actionType;

    public T getDocument() {
        if (this.properties != null) {
            return (T)this.properties;
        }
        return this.document;
    }

    public IndexAction<T> setDocument(T document) {
        if (document instanceof Map) {
            this.properties = (Map)document;
            this.document = null;
        } else {
            this.document = document;
            this.properties = null;
        }
        return this;
    }

    public IndexActionType getActionType() {
        return this.actionType;
    }

    public IndexAction<T> setActionType(IndexActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    private void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    private Map<String, Object> getProperties() {
        return this.properties;
    }

    static {
        IndexActionHelper.setAccessor(new IndexActionHelper.IndexActionAccessor(){

            @Override
            public <U> void setProperties(IndexAction<U> indexAction, Map<String, Object> properties) {
                ((IndexAction)indexAction).setProperties(properties);
            }

            @Override
            public <U> Map<String, Object> getProperties(IndexAction<U> indexAction) {
                return ((IndexAction)indexAction).getProperties();
            }
        });
    }
}

