/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.models.GeoPoint;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.implementation.util.Utility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ScoringParameter {
    private final ClientLogger logger = new ClientLogger(ScoringParameter.class);
    private final String name;
    private final List<String> values;
    private static final String DASH = "-";
    private static final String COMMA = ",";
    private static final String SINGLE_QUOTE = "'";

    public ScoringParameter(String nameValuePair) {
        Objects.requireNonNull(nameValuePair);
        if (!nameValuePair.contains(DASH)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The name and value string: %s is invalid.", nameValuePair)));
        }
        this.name = nameValuePair.split(DASH)[0];
        this.values = Arrays.asList(nameValuePair.split(DASH)[1].split(COMMA));
    }

    @JsonCreator
    public ScoringParameter(@JsonProperty(value="name") String name, @JsonProperty(value="values") List<String> values) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(values);
        this.name = name;
        this.values = new ArrayList<String>(values);
    }

    public ScoringParameter(String name, GeoPoint value) {
        this(name, ScoringParameter.toLonLatStrings(value));
    }

    private static List<String> toLonLatStrings(GeoPoint point) {
        Objects.requireNonNull(point);
        return Arrays.asList(Utility.formatCoordinate(point.getCoordinates().getLongitude()), Utility.formatCoordinate(point.getCoordinates().getLatitude()));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return new ArrayList<String>(this.values);
    }

    @JsonValue
    public String toString() {
        String flattenValue = this.values.stream().filter(value -> !CoreUtils.isNullOrEmpty((CharSequence)value)).map(ScoringParameter::escapeValue).collect(Collectors.joining(COMMA));
        if (CoreUtils.isNullOrEmpty((CharSequence)flattenValue)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("There must be at least one valid value for scoring parameter values."));
        }
        return this.name + DASH + flattenValue;
    }

    private static String escapeValue(String value) {
        if (value.contains(SINGLE_QUOTE)) {
            value = value.replace(SINGLE_QUOTE, "''");
        }
        if (value.contains(COMMA)) {
            value = SINGLE_QUOTE + value + SINGLE_QUOTE;
        }
        return value;
    }
}

