/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.util;

import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.search.documents.models.AnswerResult;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.SearchResult;
import java.util.List;
import java.util.Map;

public final class SearchPagedResponse
extends PagedResponseBase<Void, SearchResult> {
    private final List<SearchResult> value;
    private final Long count;
    private final Double coverage;
    private final Map<String, List<FacetResult>> facets;
    private final List<AnswerResult> answers;

    public SearchPagedResponse(Response<List<SearchResult>> response, String continuationToken, Map<String, List<FacetResult>> facets, Long count, Double coverage) {
        this(response, continuationToken, facets, count, coverage, null);
    }

    public SearchPagedResponse(Response<List<SearchResult>> response, String continuationToken, Map<String, List<FacetResult>> facets, Long count, Double coverage, List<AnswerResult> answers) {
        super(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), continuationToken, null);
        this.value = (List)response.getValue();
        this.facets = facets;
        this.count = count;
        this.coverage = coverage;
        this.answers = answers;
    }

    Double getCoverage() {
        return this.coverage;
    }

    Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    Long getCount() {
        return this.count;
    }

    List<AnswerResult> getAnswers() {
        return this.answers;
    }

    public List<SearchResult> getValue() {
        return this.value;
    }
}

