/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.SearchClient;
import com.azure.search.documents.SearchIndexingBufferedAsyncSender;
import com.azure.search.documents.SearchIndexingBufferedSender;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.util.Constants;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.models.SearchAudience;
import com.azure.search.documents.options.OnActionAddedOptions;
import com.azure.search.documents.options.OnActionErrorOptions;
import com.azure.search.documents.options.OnActionSentOptions;
import com.azure.search.documents.options.OnActionSucceededOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

@ServiceClientBuilder(serviceClients={SearchClient.class, SearchAsyncClient.class})
public final class SearchClientBuilder
implements AzureKeyCredentialTrait<SearchClientBuilder>,
ConfigurationTrait<SearchClientBuilder>,
EndpointTrait<SearchClientBuilder>,
HttpTrait<SearchClientBuilder>,
TokenCredentialTrait<SearchClientBuilder> {
    private static final boolean DEFAULT_AUTO_FLUSH = true;
    private static final int DEFAULT_INITIAL_BATCH_ACTION_COUNT = 512;
    private static final Duration DEFAULT_FLUSH_INTERVAL = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_RETRIES_PER_ACTION = 3;
    private static final Duration DEFAULT_THROTTLING_DELAY = Duration.ofMillis(800L);
    private static final Duration DEFAULT_MAX_THROTTLING_DELAY = Duration.ofMinutes(1L);
    private static final ClientLogger LOGGER = new ClientLogger(SearchClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private SearchAudience audience;
    private SearchServiceVersion serviceVersion;
    private String endpoint;
    private HttpClient httpClient;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions;
    private HttpLogOptions httpLogOptions;
    private Configuration configuration;
    private String indexName;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private JsonSerializer jsonSerializer;

    public SearchClient buildClient() {
        return new SearchClient(this.buildAsyncClient());
    }

    public SearchAsyncClient buildAsyncClient() {
        this.validateIndexNameAndEndpoint();
        SearchServiceVersion buildVersion = this.serviceVersion == null ? SearchServiceVersion.getLatest() : this.serviceVersion;
        HttpPipeline pipeline = this.getHttpPipeline();
        return new SearchAsyncClient(this.endpoint, this.indexName, buildVersion, pipeline, this.jsonSerializer, Utility.buildRestClient(buildVersion, this.endpoint, this.indexName, pipeline, (SerializerAdapter)Utility.getDefaultSerializerAdapter()));
    }

    public <T> SearchIndexingBufferedSenderBuilder<T> bufferedSender(TypeReference<T> documentType) {
        return new SearchIndexingBufferedSenderBuilder();
    }

    private void validateIndexNameAndEndpoint() {
        Objects.requireNonNull(this.indexName, "'indexName' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }

    private HttpPipeline getHttpPipeline() {
        if (this.httpPipeline != null) {
            return this.httpPipeline;
        }
        return Utility.buildHttpPipeline(this.clientOptions, this.httpLogOptions, this.configuration, this.retryPolicy, this.retryOptions, this.azureKeyCredential, this.tokenCredential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient, LOGGER);
    }

    public SearchClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public SearchClientBuilder credential(AzureKeyCredential credential) {
        this.azureKeyCredential = credential;
        return this;
    }

    public SearchClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = credential;
        return this;
    }

    public SearchClientBuilder audience(SearchAudience audience) {
        this.audience = audience;
        return this;
    }

    public SearchClientBuilder indexName(String indexName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)indexName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'indexName' cannot be null or empty."));
        }
        this.indexName = indexName;
        return this;
    }

    public SearchClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public static HttpLogOptions getDefaultLogOptions() {
        return Constants.DEFAULT_LOG_OPTIONS_SUPPLIER.get();
    }

    public SearchClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public SearchClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public SearchClientBuilder serializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public SearchClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            LOGGER.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public SearchClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SearchClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SearchClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SearchClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public SearchClientBuilder serviceVersion(SearchServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_FLUSH_INTERVAL;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_THROTTLING_DELAY;
    }

    static /* synthetic */ Duration access$300() {
        return DEFAULT_MAX_THROTTLING_DELAY;
    }

    @ServiceClientBuilder(serviceClients={SearchIndexingBufferedSender.class, SearchIndexingBufferedAsyncSender.class})
    public final class SearchIndexingBufferedSenderBuilder<T> {
        private final ClientLogger logger = new ClientLogger(SearchIndexingBufferedSenderBuilder.class);
        private Function<T, String> documentKeyRetriever;
        private boolean autoFlush = true;
        private Duration autoFlushInterval = SearchClientBuilder.access$100();
        private int initialBatchActionCount = 512;
        private int maxRetriesPerAction = 3;
        private Duration throttlingDelay = SearchClientBuilder.access$200();
        private Duration maxThrottlingDelay = SearchClientBuilder.access$300();
        private Consumer<OnActionAddedOptions<T>> onActionAddedConsumer;
        private Consumer<OnActionSucceededOptions<T>> onActionSucceededConsumer;
        private Consumer<OnActionErrorOptions<T>> onActionErrorConsumer;
        private Consumer<OnActionSentOptions<T>> onActionSentConsumer;

        private SearchIndexingBufferedSenderBuilder() {
        }

        public SearchIndexingBufferedSender<T> buildSender() {
            return new SearchIndexingBufferedSender<T>(this.buildAsyncSender());
        }

        public SearchIndexingBufferedAsyncSender<T> buildAsyncSender() {
            SearchClientBuilder.this.validateIndexNameAndEndpoint();
            Objects.requireNonNull(this.documentKeyRetriever, "'documentKeyRetriever' cannot be null");
            SearchServiceVersion buildVersion = SearchClientBuilder.this.serviceVersion == null ? SearchServiceVersion.getLatest() : SearchClientBuilder.this.serviceVersion;
            return new SearchIndexingBufferedAsyncSender<T>(Utility.buildRestClient(buildVersion, SearchClientBuilder.this.endpoint, SearchClientBuilder.this.indexName, SearchClientBuilder.this.getHttpPipeline(), (SerializerAdapter)Utility.getDefaultSerializerAdapter()), SearchClientBuilder.this.jsonSerializer, this.documentKeyRetriever, this.autoFlush, this.autoFlushInterval, this.initialBatchActionCount, this.maxRetriesPerAction, this.throttlingDelay, this.maxThrottlingDelay, this.onActionAddedConsumer, this.onActionSucceededConsumer, this.onActionErrorConsumer, this.onActionSentConsumer);
        }

        public SearchIndexingBufferedSenderBuilder<T> autoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> autoFlushInterval(Duration autoFlushInterval) {
            Objects.requireNonNull(autoFlushInterval, "'autoFlushInterval' cannot be null.");
            this.autoFlushInterval = autoFlushInterval;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> initialBatchActionCount(int initialBatchActionCount) {
            if (initialBatchActionCount < 1) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'batchSize' cannot be less than one."));
            }
            this.initialBatchActionCount = initialBatchActionCount;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> maxRetriesPerAction(int maxRetriesPerAction) {
            if (maxRetriesPerAction < 1) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxRetries' cannot be less than one."));
            }
            this.maxRetriesPerAction = maxRetriesPerAction;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> throttlingDelay(Duration throttlingDelay) {
            Objects.requireNonNull(throttlingDelay, "'throttlingDelay' cannot be null.");
            if (throttlingDelay.isNegative() || throttlingDelay.isZero()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'throttlingDelay' cannot be negative or zero."));
            }
            this.throttlingDelay = throttlingDelay;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> maxThrottlingDelay(Duration maxThrottlingDelay) {
            Objects.requireNonNull(maxThrottlingDelay, "'maxThrottlingDelay' cannot be null.");
            if (maxThrottlingDelay.isNegative() || maxThrottlingDelay.isZero()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxThrottlingDelay' cannot be negative or zero."));
            }
            this.maxThrottlingDelay = maxThrottlingDelay;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> onActionAdded(Consumer<OnActionAddedOptions<T>> onActionAddedConsumer) {
            this.onActionAddedConsumer = onActionAddedConsumer;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> onActionSucceeded(Consumer<OnActionSucceededOptions<T>> onActionSucceededConsumer) {
            this.onActionSucceededConsumer = onActionSucceededConsumer;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> onActionError(Consumer<OnActionErrorOptions<T>> onActionErrorConsumer) {
            this.onActionErrorConsumer = onActionErrorConsumer;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> onActionSent(Consumer<OnActionSentOptions<T>> onActionSentConsumer) {
            this.onActionSentConsumer = onActionSentConsumer;
            return this;
        }

        public SearchIndexingBufferedSenderBuilder<T> documentKeyRetriever(Function<T, String> documentKeyRetriever) {
            this.documentKeyRetriever = Objects.requireNonNull(documentKeyRetriever, "'documentKeyRetriever' cannot be null");
            return this;
        }
    }
}

