/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.indexes.implementation.models.AnalyzeRequest;
import com.azure.search.documents.indexes.models.AnalyzeTextOptions;
import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.TokenFilterName;

public final class AnalyzeRequestConverter {
    public static AnalyzeTextOptions map(AnalyzeRequest obj) {
        if (obj == null) {
            return null;
        }
        AnalyzeTextOptions analyzeTextOptions = obj.getTokenizer() != null ? new AnalyzeTextOptions(obj.getText(), obj.getTokenizer()) : new AnalyzeTextOptions(obj.getText(), obj.getAnalyzer());
        if (obj.getCharFilters() != null) {
            analyzeTextOptions.setCharFilters(obj.getCharFilters().toArray(new CharFilterName[0]));
        }
        if (obj.getTokenFilters() != null) {
            analyzeTextOptions.setTokenFilters(obj.getTokenFilters().toArray(new TokenFilterName[0]));
        }
        return analyzeTextOptions;
    }

    public static AnalyzeRequest map(AnalyzeTextOptions obj) {
        if (obj == null) {
            return null;
        }
        AnalyzeRequest analyzeRequest = new AnalyzeRequest(obj.getText());
        if (obj.getCharFilters() != null) {
            analyzeRequest.setCharFilters(obj.getCharFilters());
        }
        if (obj.getAnalyzerName() != null) {
            analyzeRequest.setAnalyzer(obj.getAnalyzerName());
        }
        if (obj.getTokenFilters() != null) {
            analyzeRequest.setTokenFilters(obj.getTokenFilters());
        }
        if (obj.getTokenizerName() != null) {
            analyzeRequest.setTokenizer(obj.getTokenizerName());
        }
        return analyzeRequest;
    }

    private AnalyzeRequestConverter() {
    }
}

