/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.search.documents.implementation.converters.IndexActionHelper;
import com.azure.search.documents.implementation.models.IndexAction;
import com.azure.search.documents.implementation.util.Utility;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class IndexActionConverter {
    private static final ClientLogger LOGGER = new ClientLogger(IndexActionConverter.class);

    public static <T> com.azure.search.documents.models.IndexAction<T> map(IndexAction obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.models.IndexAction indexAction = new com.azure.search.documents.models.IndexAction();
        if (obj.getActionType() != null) {
            indexAction.setActionType(obj.getActionType());
        }
        if (obj.getAdditionalProperties() != null) {
            Map<String, Object> properties = obj.getAdditionalProperties();
            IndexActionHelper.setProperties(indexAction, properties);
        }
        return indexAction;
    }

    public static <T> IndexAction map(com.azure.search.documents.models.IndexAction<T> obj, ObjectSerializer serializer) {
        String documentJson;
        Map<String, Object> document;
        if (obj == null) {
            return null;
        }
        IndexAction indexAction = new IndexAction();
        if (obj.getActionType() != null) {
            indexAction.setActionType(obj.getActionType());
        }
        if ((document = IndexActionHelper.getProperties(obj)) == null) {
            document = obj.getDocument();
        }
        if (serializer == null) {
            try {
                documentJson = Utility.getDefaultSerializerAdapter().serialize(document, SerializerEncoding.JSON);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        } else {
            documentJson = new String(serializer.serializeToBytes(document), StandardCharsets.UTF_8);
        }
        if (documentJson != null) {
            boolean startsWithCurlyBrace = documentJson.startsWith("{");
            boolean endsWithCurlyBrace = documentJson.endsWith("}");
            if (startsWithCurlyBrace && endsWithCurlyBrace) {
                indexAction.setRawDocument(documentJson.substring(1, documentJson.length() - 1));
            } else if (startsWithCurlyBrace) {
                indexAction.setRawDocument(documentJson.substring(1));
            } else if (endsWithCurlyBrace) {
                indexAction.setRawDocument(documentJson.substring(0, documentJson.length() - 1));
            } else {
                indexAction.setRawDocument(documentJson);
            }
        }
        return indexAction;
    }

    private IndexActionConverter() {
    }
}

