/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.indexes.implementation.models.PathHierarchyTokenizerV2;
import com.azure.search.documents.indexes.models.PathHierarchyTokenizer;

public final class PathHierarchyTokenizerConverter {
    public static PathHierarchyTokenizer map(PathHierarchyTokenizerV2 obj) {
        if (obj == null) {
            return null;
        }
        PathHierarchyTokenizer pathHierarchyTokenizer = new PathHierarchyTokenizer(obj.getName());
        Integer maxTokenLength = obj.getMaxTokenLength();
        pathHierarchyTokenizer.setMaxTokenLength(maxTokenLength);
        Character delimiter = obj.getDelimiter();
        pathHierarchyTokenizer.setDelimiter(delimiter);
        Boolean reverseTokenOrder = obj.isReverseTokenOrder();
        pathHierarchyTokenizer.setTokenOrderReversed(reverseTokenOrder);
        Integer numberOfTokensToSkip = obj.getNumberOfTokensToSkip();
        pathHierarchyTokenizer.setNumberOfTokensToSkip(numberOfTokensToSkip);
        Character replacement = obj.getReplacement();
        pathHierarchyTokenizer.setReplacement(replacement);
        return pathHierarchyTokenizer;
    }

    public static PathHierarchyTokenizerV2 map(PathHierarchyTokenizer obj) {
        if (obj == null) {
            return null;
        }
        PathHierarchyTokenizerV2 pathHierarchyTokenizerV2 = new PathHierarchyTokenizerV2(obj.getName());
        Integer maxTokenLength = obj.getMaxTokenLength();
        pathHierarchyTokenizerV2.setMaxTokenLength(maxTokenLength);
        Character delimiter = obj.getDelimiter();
        pathHierarchyTokenizerV2.setDelimiter(delimiter);
        Boolean reverseTokenOrder = obj.isTokenOrderReversed();
        pathHierarchyTokenizerV2.setReverseTokenOrder(reverseTokenOrder);
        Integer numberOfTokensToSkip = obj.getNumberOfTokensToSkip();
        pathHierarchyTokenizerV2.setNumberOfTokensToSkip(numberOfTokensToSkip);
        Character replacement = obj.getReplacement();
        pathHierarchyTokenizerV2.setReplacement(replacement);
        return pathHierarchyTokenizerV2;
    }

    private PathHierarchyTokenizerConverter() {
    }
}

