/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.LexicalTokenizerConverter;
import com.azure.search.documents.implementation.converters.TokenFilterConverter;
import com.azure.search.documents.indexes.implementation.models.LexicalTokenizer;
import com.azure.search.documents.indexes.implementation.models.SearchIndex;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SearchIndexConverter {
    public static com.azure.search.documents.indexes.models.SearchIndex map(SearchIndex obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.SearchIndex searchIndex = new com.azure.search.documents.indexes.models.SearchIndex(obj.getName(), obj.getFields());
        if (obj.getTokenizers() != null) {
            List<com.azure.search.documents.indexes.models.LexicalTokenizer> tokenizers = obj.getTokenizers().stream().map(LexicalTokenizerConverter::map).collect(Collectors.toList());
            searchIndex.setTokenizers(tokenizers);
        }
        searchIndex.setSuggesters(obj.getSuggesters());
        searchIndex.setCharFilters(obj.getCharFilters());
        if (obj.getTokenFilters() != null) {
            List<TokenFilter> tokenFilters = obj.getTokenFilters().stream().map(TokenFilterConverter::map).collect(Collectors.toList());
            searchIndex.setTokenFilters(tokenFilters);
        }
        searchIndex.setEncryptionKey(obj.getEncryptionKey());
        searchIndex.setDefaultScoringProfile(obj.getDefaultScoringProfile());
        searchIndex.setAnalyzers(obj.getAnalyzers());
        searchIndex.setSimilarity(obj.getSimilarity());
        searchIndex.setCorsOptions(obj.getCorsOptions());
        searchIndex.setETag(obj.getETag());
        searchIndex.setScoringProfiles(obj.getScoringProfiles());
        return searchIndex;
    }

    public static SearchIndex map(com.azure.search.documents.indexes.models.SearchIndex obj) {
        if (obj == null) {
            return null;
        }
        Objects.requireNonNull(obj.getName(), "The SearchIndex name cannot be null");
        SearchIndex searchIndex = new SearchIndex().setName(obj.getName()).setFields(obj.getFields());
        if (obj.getTokenizers() != null) {
            List<LexicalTokenizer> tokenizers = obj.getTokenizers().stream().map(LexicalTokenizerConverter::map).collect(Collectors.toList());
            searchIndex.setTokenizers(tokenizers);
        }
        searchIndex.setSuggesters(obj.getSuggesters());
        searchIndex.setCharFilters(obj.getCharFilters());
        if (obj.getTokenFilters() != null) {
            List<com.azure.search.documents.indexes.implementation.models.TokenFilter> tokenFilters = obj.getTokenFilters().stream().map(TokenFilterConverter::map).collect(Collectors.toList());
            searchIndex.setTokenFilters(tokenFilters);
        }
        searchIndex.setEncryptionKey(obj.getEncryptionKey());
        searchIndex.setDefaultScoringProfile(obj.getDefaultScoringProfile());
        searchIndex.setAnalyzers(obj.getAnalyzers());
        searchIndex.setSimilarity(obj.getSimilarity());
        searchIndex.setCorsOptions(obj.getCorsOptions());
        searchIndex.setETag(obj.getETag());
        searchIndex.setScoringProfiles(obj.getScoringProfiles());
        return searchIndex;
    }

    private SearchIndexConverter() {
    }
}

