/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.util.Utility;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

public final class SearchContinuationToken {
    public static final String API_VERSION = "apiVersion";
    public static final String NEXT_LINK = "nextLink";
    public static final String NEXT_PAGE_PARAMETERS = "nextPageParameters";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private SearchContinuationToken() {
    }

    public static String serializeToken(String apiVersion, String nextLink, SearchRequest nextPageParameters) {
        String nextParametersString;
        Objects.requireNonNull(apiVersion);
        if (nextLink == null || nextPageParameters == null || nextPageParameters.getSkip() == null) {
            return null;
        }
        try {
            nextParametersString = Utility.getDefaultSerializerAdapter().serialize((Object)nextPageParameters, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to serialize the search request.");
        }
        ObjectNode tokenJson = MAPPER.createObjectNode();
        tokenJson.put(API_VERSION, apiVersion);
        tokenJson.put(NEXT_LINK, nextLink);
        tokenJson.put(NEXT_PAGE_PARAMETERS, nextParametersString);
        return Base64.getEncoder().encodeToString(tokenJson.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static SearchRequest deserializeToken(String apiVersion, String continuationToken) {
        try {
            String decodedToken = new String(Base64.getDecoder().decode(continuationToken), StandardCharsets.UTF_8);
            Map tokenFields = (Map)MAPPER.readValue(decodedToken, Map.class);
            if (!apiVersion.equals(tokenFields.get(API_VERSION))) {
                throw new IllegalStateException("Continuation token uses invalid apiVersion" + apiVersion);
            }
            return (SearchRequest)Utility.getDefaultSerializerAdapter().deserialize((String)tokenFields.get(NEXT_PAGE_PARAMETERS), SearchRequest.class, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The continuation token is invalid. Token: " + continuationToken);
        }
    }
}

