/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.search.documents.SearchClient;
import com.azure.search.documents.indexes.SearchIndexAsyncClient;
import com.azure.search.documents.indexes.SearchIndexClientBuilder;
import com.azure.search.documents.indexes.models.AnalyzeTextOptions;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.FieldBuilderOptions;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.List;

@ServiceClient(builder=SearchIndexClientBuilder.class)
public final class SearchIndexClient {
    private final SearchIndexAsyncClient asyncClient;

    SearchIndexClient(SearchIndexAsyncClient searchIndexAsyncClient) {
        this.asyncClient = searchIndexAsyncClient;
    }

    HttpPipeline getHttpPipeline() {
        return this.asyncClient.getHttpPipeline();
    }

    public String getEndpoint() {
        return this.asyncClient.getEndpoint();
    }

    public SearchClient getSearchClient(String indexName) {
        return this.asyncClient.getSearchClientBuilder(indexName).buildClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndex createIndex(SearchIndex index) {
        return (SearchIndex)this.createIndexWithResponse(index, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndex> createIndexWithResponse(SearchIndex index, Context context) {
        return (Response)this.asyncClient.createIndexWithResponse(index, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndex getIndex(String indexName) {
        return (SearchIndex)this.getIndexWithResponse(indexName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndex> getIndexWithResponse(String indexName, Context context) {
        return (Response)this.asyncClient.getIndexWithResponse(indexName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexStatistics getIndexStatistics(String indexName) {
        return (SearchIndexStatistics)this.getIndexStatisticsWithResponse(indexName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexStatistics> getIndexStatisticsWithResponse(String indexName, Context context) {
        return (Response)this.asyncClient.getIndexStatisticsWithResponse(indexName, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndex> listIndexes() {
        return this.listIndexes(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndex> listIndexes(Context context) {
        return new PagedIterable(this.asyncClient.listIndexes(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexNames() {
        return this.listIndexNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexNames(Context context) {
        return new PagedIterable(this.asyncClient.listIndexNames(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndex createOrUpdateIndex(SearchIndex index) {
        return (SearchIndex)this.createOrUpdateIndexWithResponse(index, false, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndex> createOrUpdateIndexWithResponse(SearchIndex index, boolean allowIndexDowntime, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateIndexWithResponse(index, allowIndexDowntime, onlyIfUnchanged, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteIndex(String indexName) {
        this.deleteIndexWithResponse(new SearchIndex(indexName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteIndexWithResponse(SearchIndex index, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? index.getETag() : null;
        return (Response)this.asyncClient.deleteIndexWithResponse(index.getName(), etag, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions) {
        return this.analyzeText(indexName, analyzeTextOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions, Context context) {
        return new PagedIterable(this.asyncClient.analyzeText(indexName, analyzeTextOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap createSynonymMap(SynonymMap synonymMap) {
        return (SynonymMap)this.createSynonymMapWithResponse(synonymMap, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> createSynonymMapWithResponse(SynonymMap synonymMap, Context context) {
        return (Response)this.asyncClient.createSynonymMapWithResponse(synonymMap, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap getSynonymMap(String synonymMapName) {
        return (SynonymMap)this.getSynonymMapWithResponse(synonymMapName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> getSynonymMapWithResponse(String synonymMapName, Context context) {
        return (Response)this.asyncClient.getSynonymMapWithResponse(synonymMapName, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SynonymMap> listSynonymMaps() {
        return this.listSynonymMaps(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SynonymMap> listSynonymMaps(Context context) {
        return new PagedIterable(this.asyncClient.listSynonymMaps(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSynonymMapNames() {
        return this.listSynonymMapNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSynonymMapNames(Context context) {
        return new PagedIterable(this.asyncClient.listSynonymMapNames(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap createOrUpdateSynonymMap(SynonymMap synonymMap) {
        return (SynonymMap)this.createOrUpdateSynonymMapWithResponse(synonymMap, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> createOrUpdateSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateSynonymMapWithResponse(synonymMap, onlyIfUnchanged, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSynonymMap(String synonymMapName) {
        this.deleteSynonymMapWithResponse(new SynonymMap(synonymMapName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? synonymMap.getETag() : null;
        return (Response)this.asyncClient.deleteSynonymMapWithResponse(synonymMap.getName(), etag, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceStatistics getServiceStatistics() {
        return (SearchServiceStatistics)this.getServiceStatisticsWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchServiceStatistics> getServiceStatisticsWithResponse(Context context) {
        return (Response)this.asyncClient.getServiceStatisticsWithResponse(context).block();
    }

    public static List<SearchField> buildSearchFields(Class<?> model, FieldBuilderOptions options) {
        return SearchIndexAsyncClient.buildSearchFields(model, options);
    }
}

