/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.converters.SearchIndexerConverter;
import com.azure.search.documents.implementation.converters.SearchIndexerDataSourceConverter;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.indexes.SearchIndexerClientBuilder;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.ListSkillsetsResult;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SearchIndexerClientBuilder.class, isAsync=true)
public class SearchIndexerAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchIndexerAsyncClient.class);
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final SearchServiceClientImpl restClient;
    private final HttpPipeline httpPipeline;

    SearchIndexerAsyncClient(String endpoint, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline) {
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.restClient = new SearchServiceClientImpl(httpPipeline, endpoint, serviceVersion.getVersion());
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> createOrUpdateDataSourceConnection(SearchIndexerDataSourceConnection dataSource) {
        return this.createOrUpdateDataSourceConnectionWithResponse(dataSource, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> createOrUpdateDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSource, boolean onlyIfUnchanged) {
        return FluxUtil.withContext(context -> this.createOrUpdateDataSourceConnectionWithResponse(dataSource, onlyIfUnchanged, (Context)context));
    }

    Mono<Response<SearchIndexerDataSourceConnection>> createOrUpdateDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSource, boolean onlyIfUnchanged, Context context) {
        String ifMatch;
        Objects.requireNonNull(dataSource, "'DataSource' cannot be null.");
        String string = ifMatch = onlyIfUnchanged ? dataSource.getETag() : null;
        if (dataSource.getConnectionString() == null) {
            dataSource.setConnectionString("<unchanged>");
        }
        try {
            return this.restClient.getDataSources().createOrUpdateWithResponseAsync(dataSource.getName(), SearchIndexerDataSourceConverter.map(dataSource), ifMatch, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingExternalDataSource);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> createDataSourceConnection(SearchIndexerDataSourceConnection dataSource) {
        return this.createDataSourceConnectionWithResponse(dataSource).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> createDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSource) {
        return FluxUtil.withContext(context -> this.createDataSourceConnectionWithResponse(dataSource, (Context)context));
    }

    Mono<Response<SearchIndexerDataSourceConnection>> createDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSource, Context context) {
        try {
            return this.restClient.getDataSources().createWithResponseAsync(SearchIndexerDataSourceConverter.map(dataSource), null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingExternalDataSource);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerDataSourceConnection> getDataSourceConnection(String dataSourceName) {
        return this.getDataSourceConnectionWithResponse(dataSourceName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerDataSourceConnection>> getDataSourceConnectionWithResponse(String dataSourceName) {
        return FluxUtil.withContext(context -> this.getDataSourceConnectionWithResponse(dataSourceName, (Context)context));
    }

    Mono<Response<SearchIndexerDataSourceConnection>> getDataSourceConnectionWithResponse(String dataSourceName, Context context) {
        try {
            return this.restClient.getDataSources().getWithResponseAsync(dataSourceName, null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingExternalDataSource);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchIndexerDataSourceConnection> listDataSourceConnections() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDataSourceConnectionsWithResponse(null, (Context)context)).map(MappingUtils::mappingPagingDataSource));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<SearchIndexerDataSourceConnection> listDataSourceConnections(Context context) {
        try {
            return new PagedFlux(() -> this.listDataSourceConnectionsWithResponse(null, context).map(MappingUtils::mappingPagingDataSource));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listDataSourceConnectionNames() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDataSourceConnectionsWithResponse("name", (Context)context)).map(MappingUtils::mappingPagingDataSourceNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<String> listDataSourceConnectionNames(Context context) {
        try {
            return new PagedFlux(() -> this.listDataSourceConnectionsWithResponse("name", context).map(MappingUtils::mappingPagingDataSourceNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<ListDataSourcesResult>> listDataSourceConnectionsWithResponse(String select, Context context) {
        return this.restClient.getDataSources().listWithResponseAsync(select, null, context).onErrorMap(MappingUtils::exceptionMapper);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataSourceConnection(String dataSourceName) {
        return FluxUtil.withContext(context -> this.deleteDataSourceConnectionWithResponse(dataSourceName, null, (Context)context).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSource, boolean onlyIfUnchanged) {
        Objects.requireNonNull(dataSource, "'DataSource' cannot be null");
        String etag = onlyIfUnchanged ? dataSource.getETag() : null;
        return FluxUtil.withContext(context -> this.deleteDataSourceConnectionWithResponse(dataSource.getName(), etag, (Context)context));
    }

    Mono<Response<Void>> deleteDataSourceConnectionWithResponse(String dataSourceName, String etag, Context context) {
        try {
            return this.restClient.getDataSources().deleteWithResponseAsync(dataSourceName, etag, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> createIndexer(SearchIndexer indexer) {
        return this.createIndexerWithResponse(indexer).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createIndexerWithResponse(SearchIndexer indexer) {
        return FluxUtil.withContext(context -> this.createIndexerWithResponse(indexer, (Context)context));
    }

    Mono<Response<SearchIndexer>> createIndexerWithResponse(SearchIndexer indexer, Context context) {
        try {
            return this.restClient.getIndexers().createWithResponseAsync(SearchIndexerConverter.map(indexer), null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingExternalSearchIndexer);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> createOrUpdateIndexer(SearchIndexer indexer) {
        return this.createOrUpdateIndexerWithResponse(indexer, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createOrUpdateIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged) {
        return FluxUtil.withContext(context -> this.createOrUpdateIndexerWithResponse(indexer, onlyIfUnchanged, (Context)context));
    }

    Mono<Response<SearchIndexer>> createOrUpdateIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        Objects.requireNonNull(indexer, "'Indexer' cannot be 'null'");
        String ifMatch = onlyIfUnchanged ? indexer.getETag() : null;
        try {
            return this.restClient.getIndexers().createOrUpdateWithResponseAsync(indexer.getName(), SearchIndexerConverter.map(indexer), ifMatch, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingExternalSearchIndexer);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> getIndexer(String indexerName) {
        return this.getIndexerWithResponse(indexerName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> getIndexerWithResponse(String indexerName) {
        return FluxUtil.withContext(context -> this.getIndexerWithResponse(indexerName, (Context)context));
    }

    Mono<Response<SearchIndexer>> getIndexerWithResponse(String indexerName, Context context) {
        try {
            return this.restClient.getIndexers().getWithResponseAsync(indexerName, null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingExternalSearchIndexer);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchIndexer> listIndexers() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIndexersWithResponse(null, (Context)context)).map(MappingUtils::mappingPagingSearchIndexer));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<SearchIndexer> listIndexers(Context context) {
        try {
            return new PagedFlux(() -> this.listIndexersWithResponse(null, context).map(MappingUtils::mappingPagingSearchIndexer));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listIndexerNames() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIndexersWithResponse("name", (Context)context)).map(MappingUtils::mappingPagingSearchIndexerNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<String> listIndexerNames(Context context) {
        try {
            return new PagedFlux(() -> this.listIndexersWithResponse("name", context).map(MappingUtils::mappingPagingSearchIndexerNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<ListIndexersResult>> listIndexersWithResponse(String select, Context context) {
        return this.restClient.getIndexers().listWithResponseAsync(select, null, context).onErrorMap(MappingUtils::exceptionMapper);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteIndexer(String indexerName) {
        return FluxUtil.withContext(context -> this.deleteIndexerWithResponse(indexerName, null, (Context)context).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged) {
        Objects.requireNonNull(indexer, "'Indexer' cannot be null");
        String etag = onlyIfUnchanged ? indexer.getETag() : null;
        return FluxUtil.withContext(context -> this.deleteIndexerWithResponse(indexer.getName(), etag, (Context)context));
    }

    Mono<Response<Void>> deleteIndexerWithResponse(String indexerName, String etag, Context context) {
        try {
            return this.restClient.getIndexers().deleteWithResponseAsync(indexerName, etag, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetIndexer(String indexerName) {
        return this.resetIndexerWithResponse(indexerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetIndexerWithResponse(String indexerName) {
        return FluxUtil.withContext(context -> this.resetIndexerWithResponse(indexerName, (Context)context));
    }

    Mono<Response<Void>> resetIndexerWithResponse(String indexerName, Context context) {
        try {
            return this.restClient.getIndexers().resetWithResponseAsync(indexerName, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> runIndexer(String indexerName) {
        return this.runIndexerWithResponse(indexerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> runIndexerWithResponse(String indexerName) {
        return FluxUtil.withContext(context -> this.runIndexerWithResponse(indexerName, (Context)context));
    }

    Mono<Response<Void>> runIndexerWithResponse(String indexerName, Context context) {
        try {
            return this.restClient.getIndexers().runWithResponseAsync(indexerName, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerStatus> getIndexerStatus(String indexerName) {
        return this.getIndexerStatusWithResponse(indexerName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerStatus>> getIndexerStatusWithResponse(String indexerName) {
        return FluxUtil.withContext(context -> this.getIndexerStatusWithResponse(indexerName, (Context)context));
    }

    Mono<Response<SearchIndexerStatus>> getIndexerStatusWithResponse(String indexerName, Context context) {
        try {
            return this.restClient.getIndexers().getStatusWithResponseAsync(indexerName, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> createSkillset(SearchIndexerSkillset skillset) {
        return this.createSkillsetWithResponse(skillset).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> createSkillsetWithResponse(SearchIndexerSkillset skillset) {
        return FluxUtil.withContext(context -> this.createSkillsetWithResponse(skillset, (Context)context));
    }

    Mono<Response<SearchIndexerSkillset>> createSkillsetWithResponse(SearchIndexerSkillset skillset, Context context) {
        Objects.requireNonNull(skillset, "'Skillset' cannot be null.");
        try {
            return this.restClient.getSkillsets().createWithResponseAsync(skillset, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> getSkillset(String skillsetName) {
        return this.getSkillsetWithResponse(skillsetName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> getSkillsetWithResponse(String skillsetName) {
        return FluxUtil.withContext(context -> this.getSkillsetWithResponse(skillsetName, (Context)context));
    }

    Mono<Response<SearchIndexerSkillset>> getSkillsetWithResponse(String skillsetName, Context context) {
        try {
            return this.restClient.getSkillsets().getWithResponseAsync(skillsetName, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchIndexerSkillset> listSkillsets() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSkillsetsWithResponse(null, (Context)context)).map(MappingUtils::mappingPagingSkillset));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<SearchIndexerSkillset> listSkillsets(Context context) {
        try {
            return new PagedFlux(() -> this.listSkillsetsWithResponse(null, context).map(MappingUtils::mappingPagingSkillset));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listSkillsetNames() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSkillsetsWithResponse("name", (Context)context)).map(MappingUtils::mappingPagingSkillsetNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<String> listSkillsetNames(Context context) {
        try {
            return new PagedFlux(() -> this.listSkillsetsWithResponse("name", context).map(MappingUtils::mappingPagingSkillsetNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<ListSkillsetsResult>> listSkillsetsWithResponse(String select, Context context) {
        return this.restClient.getSkillsets().listWithResponseAsync(select, null, context).onErrorMap(MappingUtils::exceptionMapper);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerSkillset> createOrUpdateSkillset(SearchIndexerSkillset skillset) {
        return this.createOrUpdateSkillsetWithResponse(skillset, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerSkillset>> createOrUpdateSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged) {
        return FluxUtil.withContext(context -> this.createOrUpdateSkillsetWithResponse(skillset, onlyIfUnchanged, (Context)context));
    }

    Mono<Response<SearchIndexerSkillset>> createOrUpdateSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        Objects.requireNonNull(skillset, "'Skillset' cannot be null.");
        String ifMatch = onlyIfUnchanged ? skillset.getETag() : null;
        try {
            return this.restClient.getSkillsets().createOrUpdateWithResponseAsync(skillset.getName(), skillset, ifMatch, null, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSkillset(String skillsetName) {
        return FluxUtil.withContext(context -> this.deleteSkillsetWithResponse(skillsetName, null, (Context)context).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged) {
        Objects.requireNonNull(skillset, "'Skillset' cannot be null.");
        String etag = onlyIfUnchanged ? skillset.getETag() : null;
        return FluxUtil.withContext(context -> this.deleteSkillsetWithResponse(skillset.getName(), etag, (Context)context));
    }

    Mono<Response<Void>> deleteSkillsetWithResponse(String skillsetName, String etag, Context context) {
        try {
            return this.restClient.getSkillsets().deleteWithResponseAsync(skillsetName, etag, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }
}

