/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.search.documents.indexes.SearchIndexerAsyncClient;
import com.azure.search.documents.indexes.SearchIndexerClientBuilder;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;

@ServiceClient(builder=SearchIndexerClientBuilder.class)
public class SearchIndexerClient {
    private final SearchIndexerAsyncClient asyncClient;

    SearchIndexerClient(SearchIndexerAsyncClient searchIndexerAsyncClient) {
        this.asyncClient = searchIndexerAsyncClient;
    }

    HttpPipeline getHttpPipeline() {
        return this.asyncClient.getHttpPipeline();
    }

    public String getEndpoint() {
        return this.asyncClient.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection createOrUpdateDataSourceConnection(SearchIndexerDataSourceConnection dataSourceConnection) {
        return (SearchIndexerDataSourceConnection)this.createOrUpdateDataSourceConnectionWithResponse(dataSourceConnection, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createOrUpdateDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateDataSourceConnectionWithResponse(dataSourceConnection, onlyIfUnchanged, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection createDataSourceConnection(SearchIndexerDataSourceConnection dataSourceConnection) {
        return (SearchIndexerDataSourceConnection)this.createDataSourceConnectionWithResponse(dataSourceConnection, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, Context context) {
        return (Response)this.asyncClient.createDataSourceConnectionWithResponse(dataSourceConnection, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection getDataSourceConnection(String dataSourceConnectionName) {
        return (SearchIndexerDataSourceConnection)this.getDataSourceConnectionWithResponse(dataSourceConnectionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> getDataSourceConnectionWithResponse(String dataSourceConnectionName, Context context) {
        return (Response)this.asyncClient.getDataSourceConnectionWithResponse(dataSourceConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerDataSourceConnection> listDataSourceConnections() {
        return this.listDataSourceConnections(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerDataSourceConnection> listDataSourceConnections(Context context) {
        return new PagedIterable(this.asyncClient.listDataSourceConnections(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listDataSourceConnectionNames() {
        return this.listDataSourceConnectionNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listDataSourceConnectionNames(Context context) {
        return new PagedIterable(this.asyncClient.listDataSourceConnectionNames(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataSourceConnection(String dataSourceConnectionName) {
        this.deleteDataSourceConnectionWithResponse(new SearchIndexerDataSourceConnection(dataSourceConnectionName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? dataSourceConnection.getETag() : null;
        return (Response)this.asyncClient.deleteDataSourceConnectionWithResponse(dataSourceConnection.getName(), etag, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer createIndexer(SearchIndexer indexer) {
        return (SearchIndexer)this.createIndexerWithResponse(indexer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createIndexerWithResponse(SearchIndexer indexer, Context context) {
        return (Response)this.asyncClient.createIndexerWithResponse(indexer, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer createOrUpdateIndexer(SearchIndexer indexer) {
        return (SearchIndexer)this.createOrUpdateIndexerWithResponse(indexer, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createOrUpdateIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateIndexerWithResponse(indexer, onlyIfUnchanged, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexer> listIndexers() {
        return this.listIndexers(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexer> listIndexers(Context context) {
        return new PagedIterable(this.asyncClient.listIndexers(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexerNames() {
        return this.listIndexerNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexerNames(Context context) {
        return new PagedIterable(this.asyncClient.listIndexerNames(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer getIndexer(String indexerName) {
        return (SearchIndexer)this.getIndexerWithResponse(indexerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> getIndexerWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.getIndexerWithResponse(indexerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteIndexer(String indexerName) {
        this.deleteIndexerWithResponse(new SearchIndexer(indexerName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? indexer.getETag() : null;
        return (Response)this.asyncClient.deleteIndexerWithResponse(indexer.getName(), etag, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetIndexer(String indexerName) {
        this.resetIndexerWithResponse(indexerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetIndexerWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.resetIndexerWithResponse(indexerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void runIndexer(String indexerName) {
        this.runIndexerWithResponse(indexerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> runIndexerWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.runIndexerWithResponse(indexerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerStatus getIndexerStatus(String indexerName) {
        return (SearchIndexerStatus)this.getIndexerStatusWithResponse(indexerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerStatus> getIndexerStatusWithResponse(String indexerName, Context context) {
        return (Response)this.asyncClient.getIndexerStatusWithResponse(indexerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset createSkillset(SearchIndexerSkillset skillset) {
        return (SearchIndexerSkillset)this.createSkillsetWithResponse(skillset, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createSkillsetWithResponse(SearchIndexerSkillset skillset, Context context) {
        return (Response)this.asyncClient.createSkillsetWithResponse(skillset, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset getSkillset(String skillsetName) {
        return (SearchIndexerSkillset)this.getSkillsetWithResponse(skillsetName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> getSkillsetWithResponse(String skillsetName, Context context) {
        return (Response)this.asyncClient.getSkillsetWithResponse(skillsetName, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerSkillset> listSkillsets() {
        return this.listSkillsets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerSkillset> listSkillsets(Context context) {
        return new PagedIterable(this.asyncClient.listSkillsets(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSkillsetNames() {
        return this.listSkillsetNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSkillsetNames(Context context) {
        return new PagedIterable(this.asyncClient.listSkillsetNames(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset createOrUpdateSkillset(SearchIndexerSkillset skillset) {
        return (SearchIndexerSkillset)this.createOrUpdateSkillsetWithResponse(skillset, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createOrUpdateSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        return (Response)this.asyncClient.createOrUpdateSkillsetWithResponse(skillset, onlyIfUnchanged, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSkillset(String skillsetName) {
        this.deleteSkillsetWithResponse(new SearchIndexerSkillset(skillsetName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? skillset.getETag() : null;
        return (Response)this.asyncClient.deleteSkillsetWithResponse(skillset.getName(), etag, context).block();
    }
}

