/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.util.Constants;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.SearchIndexerAsyncClient;
import com.azure.search.documents.indexes.SearchIndexerClient;
import com.azure.search.documents.models.SearchAudience;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={SearchIndexerClient.class, SearchIndexerAsyncClient.class})
public class SearchIndexerClientBuilder
implements AzureKeyCredentialTrait<SearchIndexerClientBuilder>,
ConfigurationTrait<SearchIndexerClientBuilder>,
EndpointTrait<SearchIndexerClientBuilder>,
HttpTrait<SearchIndexerClientBuilder>,
TokenCredentialTrait<SearchIndexerClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(SearchIndexerClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private SearchAudience audience;
    private SearchServiceVersion serviceVersion;
    private String endpoint;
    private HttpClient httpClient;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions;
    private HttpLogOptions httpLogOptions;
    private Configuration configuration;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;

    public SearchIndexerClient buildClient() {
        return new SearchIndexerClient(this.buildAsyncClient());
    }

    public SearchIndexerAsyncClient buildAsyncClient() {
        SearchServiceVersion buildVersion;
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
        SearchServiceVersion searchServiceVersion = buildVersion = this.serviceVersion == null ? SearchServiceVersion.getLatest() : this.serviceVersion;
        if (this.httpPipeline != null) {
            return new SearchIndexerAsyncClient(this.endpoint, buildVersion, this.httpPipeline);
        }
        HttpPipeline pipeline = Utility.buildHttpPipeline(this.clientOptions, this.httpLogOptions, this.configuration, this.retryPolicy, this.retryOptions, this.azureKeyCredential, this.tokenCredential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient, LOGGER);
        return new SearchIndexerAsyncClient(this.endpoint, buildVersion, pipeline);
    }

    public SearchIndexerClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public SearchIndexerClientBuilder credential(AzureKeyCredential credential) {
        this.azureKeyCredential = credential;
        return this;
    }

    public SearchIndexerClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = credential;
        return this;
    }

    public SearchIndexerClientBuilder audience(SearchAudience audience) {
        this.audience = audience;
        return this;
    }

    public SearchIndexerClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public static HttpLogOptions getDefaultLogOptions() {
        return Constants.DEFAULT_LOG_OPTIONS_SUPPLIER.get();
    }

    public SearchIndexerClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public SearchIndexerClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public SearchIndexerClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            LOGGER.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public SearchIndexerClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SearchIndexerClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SearchIndexerClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SearchIndexerClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public SearchIndexerClientBuilder serviceVersion(SearchServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }
}

