/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;

public final class AnalyzeTextOptions {
    @JsonProperty(value="text", required=true)
    private final String text;
    @JsonProperty(value="analyzer")
    private LexicalAnalyzerName analyzerName;
    @JsonProperty(value="tokenizer")
    private LexicalTokenizerName tokenizerName;
    @JsonProperty(value="tokenFilters")
    private List<TokenFilterName> tokenFilters;
    @JsonProperty(value="charFilters")
    private List<CharFilterName> charFilters;

    public AnalyzeTextOptions(String text, LexicalAnalyzerName analyzerName) {
        this.text = text;
        this.analyzerName = analyzerName;
        this.tokenizerName = null;
    }

    public AnalyzeTextOptions(String text, LexicalTokenizerName tokenizerName) {
        this.text = text;
        this.tokenizerName = tokenizerName;
        this.analyzerName = null;
    }

    public String getText() {
        return this.text;
    }

    public LexicalAnalyzerName getAnalyzerName() {
        return this.analyzerName;
    }

    public LexicalTokenizerName getTokenizerName() {
        return this.tokenizerName;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeTextOptions setTokenFilters(TokenFilterName ... tokenFilters) {
        this.tokenFilters = tokenFilters == null ? null : Arrays.asList(tokenFilters);
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public AnalyzeTextOptions setCharFilters(CharFilterName ... charFilters) {
        this.charFilters = charFilters == null ? null : Arrays.asList(charFilters);
        return this;
    }
}

