/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Azure.Search.CustomAnalyzer")
public final class CustomAnalyzer
extends LexicalAnalyzer {
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Azure.Search.CustomAnalyzer";
    @JsonProperty(value="tokenizer", required=true)
    private LexicalTokenizerName tokenizer;
    @JsonProperty(value="tokenFilters")
    private List<TokenFilterName> tokenFilters;
    @JsonProperty(value="charFilters")
    private List<CharFilterName> charFilters;

    @JsonCreator
    public CustomAnalyzer(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="tokenizer", required=true) LexicalTokenizerName tokenizer) {
        super(name);
        this.tokenizer = tokenizer;
    }

    public LexicalTokenizerName getTokenizer() {
        return this.tokenizer;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    @JsonSetter
    public CustomAnalyzer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    @JsonSetter
    public CustomAnalyzer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    public CustomAnalyzer setTokenFilters(TokenFilterName ... tokenFilters) {
        this.tokenFilters = tokenFilters == null ? null : Arrays.asList(tokenFilters);
        return this;
    }

    public CustomAnalyzer setCharFilters(CharFilterName ... charFilters) {
        this.charFilters = charFilters == null ? null : Arrays.asList(charFilters);
        return this;
    }
}

