/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.CustomEntity;
import com.azure.search.documents.indexes.models.CustomEntityLookupSkillLanguage;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Skills.Text.CustomEntityLookupSkill")
public final class CustomEntityLookupSkill
extends SearchIndexerSkill {
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Skills.Text.CustomEntityLookupSkill";
    @JsonProperty(value="defaultLanguageCode")
    private CustomEntityLookupSkillLanguage defaultLanguageCode;
    @JsonProperty(value="entitiesDefinitionUri")
    private String entitiesDefinitionUri;
    @JsonProperty(value="inlineEntitiesDefinition")
    private List<CustomEntity> inlineEntitiesDefinition;
    @JsonProperty(value="globalDefaultCaseSensitive")
    private Boolean globalDefaultCaseSensitive;
    @JsonProperty(value="globalDefaultAccentSensitive")
    private Boolean globalDefaultAccentSensitive;
    @JsonProperty(value="globalDefaultFuzzyEditDistance")
    private Integer globalDefaultFuzzyEditDistance;

    @JsonCreator
    public CustomEntityLookupSkill(@JsonProperty(value="inputs", required=true) List<InputFieldMappingEntry> inputs, @JsonProperty(value="outputs", required=true) List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public CustomEntityLookupSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public CustomEntityLookupSkill setDefaultLanguageCode(CustomEntityLookupSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public String getEntitiesDefinitionUri() {
        return this.entitiesDefinitionUri;
    }

    public CustomEntityLookupSkill setEntitiesDefinitionUri(String entitiesDefinitionUri) {
        this.entitiesDefinitionUri = entitiesDefinitionUri;
        return this;
    }

    public List<CustomEntity> getInlineEntitiesDefinition() {
        return this.inlineEntitiesDefinition;
    }

    @JsonSetter
    public CustomEntityLookupSkill setInlineEntitiesDefinition(List<CustomEntity> inlineEntitiesDefinition) {
        this.inlineEntitiesDefinition = inlineEntitiesDefinition;
        return this;
    }

    public Boolean isGlobalDefaultCaseSensitive() {
        return this.globalDefaultCaseSensitive;
    }

    public CustomEntityLookupSkill setGlobalDefaultCaseSensitive(Boolean globalDefaultCaseSensitive) {
        this.globalDefaultCaseSensitive = globalDefaultCaseSensitive;
        return this;
    }

    public Boolean isGlobalDefaultAccentSensitive() {
        return this.globalDefaultAccentSensitive;
    }

    public CustomEntityLookupSkill setGlobalDefaultAccentSensitive(Boolean globalDefaultAccentSensitive) {
        this.globalDefaultAccentSensitive = globalDefaultAccentSensitive;
        return this;
    }

    public Integer getGlobalDefaultFuzzyEditDistance() {
        return this.globalDefaultFuzzyEditDistance;
    }

    public CustomEntityLookupSkill setGlobalDefaultFuzzyEditDistance(Integer globalDefaultFuzzyEditDistance) {
        this.globalDefaultFuzzyEditDistance = globalDefaultFuzzyEditDistance;
        return this;
    }

    @Override
    public CustomEntityLookupSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public CustomEntityLookupSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CustomEntityLookupSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    public CustomEntityLookupSkill setInlineEntitiesDefinition(CustomEntity ... inlineEntitiesDefinition) {
        this.inlineEntitiesDefinition = inlineEntitiesDefinition == null ? null : Arrays.asList(inlineEntitiesDefinition);
        return this;
    }
}

