/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.EntityCategory;
import com.azure.search.documents.indexes.models.EntityRecognitionSkillLanguage;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@odata.type", visible=true)
@JsonTypeName(value="#Microsoft.Skills.Text.EntityRecognitionSkill")
public final class EntityRecognitionSkill
extends SearchIndexerSkill {
    @JsonTypeId
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Skills.Text.EntityRecognitionSkill";
    @JsonProperty(value="categories")
    private List<EntityCategory> categories;
    @JsonProperty(value="defaultLanguageCode")
    private EntityRecognitionSkillLanguage defaultLanguageCode;
    @JsonProperty(value="includeTypelessEntities")
    private Boolean includeTypelessEntities;
    @JsonProperty(value="minimumPrecision")
    private Double minimumPrecision;

    @JsonCreator
    public EntityRecognitionSkill(@JsonProperty(value="inputs", required=true) List<InputFieldMappingEntry> inputs, @JsonProperty(value="outputs", required=true) List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public List<EntityCategory> getCategories() {
        return this.categories;
    }

    @JsonSetter
    public EntityRecognitionSkill setCategories(List<EntityCategory> categories) {
        this.categories = categories;
        return this;
    }

    public EntityRecognitionSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public EntityRecognitionSkill setDefaultLanguageCode(EntityRecognitionSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Boolean areTypelessEntitiesIncluded() {
        return this.includeTypelessEntities;
    }

    public EntityRecognitionSkill setTypelessEntitiesIncluded(Boolean includeTypelessEntities) {
        this.includeTypelessEntities = includeTypelessEntities;
        return this;
    }

    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    public EntityRecognitionSkill setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    @Override
    public EntityRecognitionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public EntityRecognitionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public EntityRecognitionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    public EntityRecognitionSkill setCategories(EntityCategory ... categories) {
        this.categories = categories == null ? null : Arrays.asList(categories);
        return this;
    }
}

