/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.SearchFieldDataType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Arrays;
import java.util.List;

public final class SearchField {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type", required=true)
    private SearchFieldDataType type;
    @JsonProperty(value="key")
    private Boolean key;
    @JsonProperty(value="retrievable")
    private Boolean hidden;
    @JsonProperty(value="searchable")
    private Boolean searchable;
    @JsonProperty(value="filterable")
    private Boolean filterable;
    @JsonProperty(value="sortable")
    private Boolean sortable;
    @JsonProperty(value="facetable")
    private Boolean facetable;
    @JsonProperty(value="analyzer")
    private LexicalAnalyzerName analyzerName;
    @JsonProperty(value="searchAnalyzer")
    private LexicalAnalyzerName searchAnalyzerName;
    @JsonProperty(value="indexAnalyzer")
    private LexicalAnalyzerName indexAnalyzerName;
    @JsonProperty(value="synonymMaps")
    private List<String> synonymMapNames;
    @JsonProperty(value="fields")
    private List<SearchField> fields;

    @JsonCreator
    public SearchField(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type", required=true) SearchFieldDataType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public SearchFieldDataType getType() {
        return this.type;
    }

    public Boolean isKey() {
        return this.key;
    }

    public SearchField setKey(Boolean key) {
        this.key = key;
        return this;
    }

    public Boolean isHidden() {
        return this.hidden == null ? null : Boolean.valueOf(this.hidden == false);
    }

    public SearchField setHidden(Boolean hidden) {
        this.hidden = hidden == null ? null : Boolean.valueOf(hidden == false);
        return this;
    }

    public Boolean isSearchable() {
        return this.searchable;
    }

    public SearchField setSearchable(Boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public Boolean isFilterable() {
        return this.filterable;
    }

    public SearchField setFilterable(Boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    public Boolean isSortable() {
        return this.sortable;
    }

    public SearchField setSortable(Boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public Boolean isFacetable() {
        return this.facetable;
    }

    public SearchField setFacetable(Boolean facetable) {
        this.facetable = facetable;
        return this;
    }

    public LexicalAnalyzerName getAnalyzerName() {
        return this.analyzerName;
    }

    public SearchField setAnalyzerName(LexicalAnalyzerName analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public LexicalAnalyzerName getSearchAnalyzerName() {
        return this.searchAnalyzerName;
    }

    public SearchField setSearchAnalyzerName(LexicalAnalyzerName searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        return this;
    }

    public LexicalAnalyzerName getIndexAnalyzerName() {
        return this.indexAnalyzerName;
    }

    public SearchField setIndexAnalyzerName(LexicalAnalyzerName indexAnalyzerName) {
        this.indexAnalyzerName = indexAnalyzerName;
        return this;
    }

    public List<String> getSynonymMapNames() {
        return this.synonymMapNames;
    }

    @JsonSetter
    public SearchField setSynonymMapNames(List<String> synonymMapNames) {
        this.synonymMapNames = synonymMapNames;
        return this;
    }

    public List<SearchField> getFields() {
        return this.fields;
    }

    @JsonSetter
    public SearchField setFields(List<SearchField> fields) {
        this.fields = fields;
        return this;
    }

    public SearchField setFields(SearchField ... fields) {
        this.fields = fields == null ? null : Arrays.asList(fields);
        return this;
    }

    public SearchField setSynonymMapNames(String ... synonymMapNames) {
        this.synonymMapNames = synonymMapNames == null ? null : Arrays.asList(synonymMapNames);
        return this;
    }
}

