/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.implementation.models.AzureActiveDirectoryApplicationCredentials;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SearchResourceEncryptionKey {
    @JsonProperty(value="keyVaultKeyName", required=true)
    private String keyName;
    @JsonProperty(value="keyVaultKeyVersion", required=true)
    private String keyVersion;
    @JsonProperty(value="keyVaultUri", required=true)
    private String vaultUrl;
    @JsonProperty(value="accessCredentials")
    private AzureActiveDirectoryApplicationCredentials accessCredentials;

    @JsonCreator
    public SearchResourceEncryptionKey(@JsonProperty(value="keyVaultKeyName", required=true) String keyName, @JsonProperty(value="keyVaultKeyVersion", required=true) String keyVersion, @JsonProperty(value="keyVaultUri", required=true) String vaultUrl) {
        this.keyName = keyName;
        this.keyVersion = keyVersion;
        this.vaultUrl = vaultUrl;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getApplicationId() {
        return this.accessCredentials == null ? null : this.accessCredentials.getApplicationId();
    }

    public SearchResourceEncryptionKey setApplicationId(String applicationId) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationId(applicationId);
        return this;
    }

    public String getApplicationSecret() {
        return this.accessCredentials == null ? null : this.accessCredentials.getApplicationSecret();
    }

    public SearchResourceEncryptionKey setApplicationSecret(String applicationSecret) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationSecret(applicationSecret);
        return this;
    }
}

