/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.implementation.converters.SearchResultHelper;
import com.azure.search.documents.implementation.util.Utility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SearchResult {
    private static final ClientLogger LOGGER = new ClientLogger(SearchResult.class);
    @JsonProperty(value="@search.score", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private double score;
    @JsonProperty(value="@search.highlights", access=JsonProperty.Access.WRITE_ONLY)
    private Map<String, List<String>> highlights;
    @JsonIgnore
    private Map<String, Object> additionalProperties;
    @JsonIgnore
    private JsonSerializer jsonSerializer;

    @JsonCreator
    public SearchResult(@JsonProperty(value="@search.score", required=true, access=JsonProperty.Access.WRITE_ONLY) double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public Map<String, List<String>> getHighlights() {
        return this.highlights;
    }

    public <T> T getDocument(Class<T> modelClass) {
        if (this.jsonSerializer == null) {
            try {
                return Utility.convertValue(this.additionalProperties, modelClass);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to deserialize search result.", ex));
            }
        }
        byte[] rawJsonDocument = this.jsonSerializer.serializeToBytes(this.additionalProperties);
        return (T)this.jsonSerializer.deserializeFromBytes(rawJsonDocument, TypeReference.createInstance(modelClass));
    }

    private void setAdditionalProperties(SearchDocument additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    private void setHighlights(Map<String, List<String>> highlights) {
        this.highlights = highlights;
    }

    private void setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    static {
        SearchResultHelper.setAccessor(new SearchResultHelper.SearchResultAccessor(){

            @Override
            public void setAdditionalProperties(SearchResult searchResult, SearchDocument additionalProperties) {
                searchResult.setAdditionalProperties(additionalProperties);
            }

            @Override
            public void setHighlights(SearchResult searchResult, Map<String, List<String>> highlights) {
                searchResult.setHighlights(highlights);
            }

            @Override
            public void setJsonSerializer(SearchResult searchResult, JsonSerializer jsonSerializer) {
                searchResult.setJsonSerializer(jsonSerializer);
            }
        });
    }
}

