/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.implementation.converters.SuggestResultHelper;
import com.azure.search.documents.implementation.util.Utility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SuggestResult {
    private static final ClientLogger LOGGER = new ClientLogger(SuggestResult.class);
    @JsonProperty(value="")
    private SearchDocument additionalProperties;
    @JsonProperty(value="@search.text", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private String text;
    @JsonIgnore
    private JsonSerializer jsonSerializer;

    @JsonCreator
    public SuggestResult(@JsonProperty(value="@search.text", required=true, access=JsonProperty.Access.WRITE_ONLY) String text) {
        this.text = text;
    }

    public <T> T getDocument(Class<T> modelClass) {
        if (this.jsonSerializer == null) {
            try {
                return Utility.convertValue(this.additionalProperties, modelClass);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to deserialize suggestion result.", ex));
            }
        }
        ByteArrayOutputStream sourceStream = new ByteArrayOutputStream();
        this.jsonSerializer.serialize((OutputStream)sourceStream, (Object)this.additionalProperties);
        return (T)this.jsonSerializer.deserialize((InputStream)new ByteArrayInputStream(sourceStream.toByteArray()), TypeReference.createInstance(modelClass));
    }

    public String getText() {
        return this.text;
    }

    private void setAdditionalProperties(SearchDocument additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    static {
        SuggestResultHelper.setAccessor(new SuggestResultHelper.SuggestResultAccessor(){

            @Override
            public void setAdditionalProperties(SuggestResult suggestResult, SearchDocument additionalProperties) {
                suggestResult.setAdditionalProperties(additionalProperties);
            }
        });
    }
}

