/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.models.GeoPoint;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.MemberNameConverter;
import com.azure.core.util.serializer.MemberNameConverterProviders;
import com.azure.search.documents.indexes.FieldBuilderIgnore;
import com.azure.search.documents.indexes.SearchableField;
import com.azure.search.documents.indexes.SimpleField;
import com.azure.search.documents.indexes.models.FieldBuilderOptions;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.LexicalNormalizerName;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchFieldDataType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.util.annotation.Nullable;

public final class FieldBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(FieldBuilder.class);
    private static final int MAX_DEPTH = 10000;
    private static final Map<Type, SearchFieldDataType> SUPPORTED_NONE_PARAMETERIZED_TYPE = new HashMap<Type, SearchFieldDataType>();
    private static final Set<Type> UNSUPPORTED_TYPES = new HashSet<Type>();
    private static final SearchFieldDataType COLLECTION_STRING = SearchFieldDataType.collection(SearchFieldDataType.STRING);

    public static <T> List<SearchField> build(Class<T> modelClass, FieldBuilderOptions options) {
        JsonSerializer serializer;
        MemberNameConverter converter = options == null || options.getJsonSerializer() == null ? MemberNameConverterProviders.createInstance() : ((serializer = options.getJsonSerializer()) instanceof MemberNameConverter ? (MemberNameConverter)serializer : MemberNameConverterProviders.createInstance());
        return FieldBuilder.build(modelClass, new Stack(), converter);
    }

    private static List<SearchField> build(Class<?> currentClass, Stack<Class<?>> classChain, MemberNameConverter serializer) {
        if (classChain.contains(currentClass)) {
            LOGGER.warning("There is circular dependencies {}, {}", new Object[]{classChain, currentClass});
            return null;
        }
        if (classChain.size() > 10000) {
            throw LOGGER.logExceptionAsError(new RuntimeException("The dependency graph is too deep. Please review your schema."));
        }
        classChain.push(currentClass);
        List<SearchField> searchFields = FieldBuilder.getDeclaredFieldsAndMethods(currentClass).filter(FieldBuilder::fieldOrMethodIgnored).map(classField -> FieldBuilder.buildSearchField(classField, classChain, serializer)).filter(Objects::nonNull).collect(Collectors.toList());
        classChain.pop();
        return searchFields;
    }

    private static Stream<Member> getDeclaredFieldsAndMethods(Class<?> model) {
        ArrayList<Field> fieldsAndMethods = new ArrayList<Field>(Arrays.asList(model.getDeclaredFields()));
        fieldsAndMethods.addAll(Arrays.asList(model.getDeclaredMethods()));
        return fieldsAndMethods.stream();
    }

    private static boolean fieldOrMethodIgnored(Member member) {
        if (member instanceof Field) {
            return !((Field)member).isAnnotationPresent(FieldBuilderIgnore.class);
        }
        if (member instanceof Method) {
            return !((Method)member).isAnnotationPresent(FieldBuilderIgnore.class);
        }
        return false;
    }

    private static SearchField buildSearchField(Member member, Stack<Class<?>> classChain, MemberNameConverter serializer) {
        String fieldName = serializer.convertMemberName(member);
        if (fieldName == null) {
            return null;
        }
        Type type = FieldBuilder.getFieldOrMethodReturnType(member);
        if (SUPPORTED_NONE_PARAMETERIZED_TYPE.containsKey(type)) {
            return FieldBuilder.buildNoneParameterizedType(fieldName, member, type);
        }
        if (FieldBuilder.isArrayOrList(type)) {
            return FieldBuilder.buildCollectionField(fieldName, member, type, classChain, serializer);
        }
        return FieldBuilder.getSearchField(type, classChain, serializer, fieldName, (Class)type);
    }

    private static Type getFieldOrMethodReturnType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Member isn't instance of Field or Method."));
    }

    @Nullable
    private static SearchField getSearchField(Type type, Stack<Class<?>> classChain, MemberNameConverter serializer, String fieldName, Class<?> clazz) {
        SearchField searchField = FieldBuilder.convertToBasicSearchField(fieldName, type);
        if (searchField == null) {
            return null;
        }
        return searchField.setFields(FieldBuilder.build(clazz, classChain, serializer));
    }

    private static SearchField buildNoneParameterizedType(String fieldName, Member member, Type type) {
        SearchField searchField = FieldBuilder.convertToBasicSearchField(fieldName, type);
        return searchField == null ? null : FieldBuilder.enrichWithAnnotation(searchField, member);
    }

    private static boolean isArrayOrList(Type type) {
        return FieldBuilder.isList(type) || ((Class)type).isArray();
    }

    private static boolean isList(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        Type rawType = ((ParameterizedType)type).getRawType();
        return List.class.isAssignableFrom((Class)rawType);
    }

    private static SearchField buildCollectionField(String fieldName, Member member, Type type, Stack<Class<?>> classChain, MemberNameConverter serializer) {
        Type componentOrElementType = FieldBuilder.getComponentOrElementType(type);
        FieldBuilder.validateType(componentOrElementType, true);
        if (SUPPORTED_NONE_PARAMETERIZED_TYPE.containsKey(componentOrElementType)) {
            SearchField searchField = FieldBuilder.convertToBasicSearchField(fieldName, type);
            if (searchField == null) {
                return null;
            }
            return FieldBuilder.enrichWithAnnotation(searchField, member);
        }
        return FieldBuilder.getSearchField(type, classChain, serializer, fieldName, (Class)componentOrElementType);
    }

    private static Type getComponentOrElementType(Type arrayOrListType) {
        if (FieldBuilder.isList(arrayOrListType)) {
            ParameterizedType pt = (ParameterizedType)arrayOrListType;
            return pt.getActualTypeArguments()[0];
        }
        if (((Class)arrayOrListType).isArray()) {
            return ((Class)arrayOrListType).getComponentType();
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Collection type '" + arrayOrListType.getTypeName() + "' is not supported."));
    }

    private static SearchField convertToBasicSearchField(String fieldName, Type type) {
        SearchFieldDataType dataType = FieldBuilder.covertToSearchFieldDataType(type, false);
        return dataType == null ? null : new SearchField(fieldName, dataType);
    }

    private static SearchField enrichWithAnnotation(SearchField searchField, Member member) {
        boolean hasNormalizerName;
        String normalizerName;
        boolean facetable;
        boolean sortable;
        boolean filterable;
        boolean hidden;
        boolean key;
        SimpleField simpleField = FieldBuilder.getDeclaredAnnotation(member, SimpleField.class);
        SearchableField searchableField = FieldBuilder.getDeclaredAnnotation(member, SearchableField.class);
        if (simpleField != null && searchableField != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("@SimpleField and @SearchableField cannot be present simultaneously for " + member.getName()));
        }
        if (simpleField == null && searchableField == null) {
            return searchField;
        }
        boolean searchable = searchableField != null;
        String analyzerName = null;
        String searchAnalyzerName = null;
        String indexAnalyzerName = null;
        Object[] synonymMapNames = null;
        if (simpleField != null) {
            key = simpleField.isKey();
            hidden = simpleField.isHidden();
            filterable = simpleField.isFilterable();
            sortable = simpleField.isSortable();
            facetable = simpleField.isFacetable();
            normalizerName = simpleField.normalizerName();
        } else {
            key = searchableField.isKey();
            hidden = searchableField.isHidden();
            filterable = searchableField.isFilterable();
            sortable = searchableField.isSortable();
            facetable = searchableField.isFacetable();
            analyzerName = searchableField.analyzerName();
            searchAnalyzerName = searchableField.searchAnalyzerName();
            indexAnalyzerName = searchableField.indexAnalyzerName();
            normalizerName = searchableField.normalizerName();
            synonymMapNames = searchableField.synonymMapNames();
        }
        StringBuilder errorMessage = new StringBuilder();
        boolean isStringOrCollectionString = searchField.getType() == SearchFieldDataType.STRING || searchField.getType() == COLLECTION_STRING;
        boolean hasAnalyzerName = !CoreUtils.isNullOrEmpty((CharSequence)analyzerName);
        boolean hasSearchAnalyzerName = !CoreUtils.isNullOrEmpty((CharSequence)searchAnalyzerName);
        boolean hasIndexAnalyzerName = !CoreUtils.isNullOrEmpty((CharSequence)indexAnalyzerName);
        boolean bl = hasNormalizerName = !CoreUtils.isNullOrEmpty((CharSequence)normalizerName);
        if (searchable) {
            if (!isStringOrCollectionString) {
                errorMessage.append("SearchField can only be used on string properties. Property '").append(member.getName()).append("' returns a '").append((Object)searchField.getType()).append("' value. ");
            }
            if (!hasAnalyzerName && hasSearchAnalyzerName != hasIndexAnalyzerName || hasAnalyzerName && (hasSearchAnalyzerName || hasIndexAnalyzerName)) {
                errorMessage.append("Please specify either analyzer or both searchAnalyzer and indexAnalyzer. ");
            }
        }
        if (!(!hasNormalizerName || isStringOrCollectionString && (filterable || sortable || facetable))) {
            errorMessage.append("A field with a normalizer name can only be used on string properties and must have ").append("one of filterable, sortable, or facetable set to true. ");
        }
        if (errorMessage.length() > 0) {
            throw LOGGER.logExceptionAsError(new RuntimeException(errorMessage.toString()));
        }
        searchField.setKey(key).setHidden(hidden).setSearchable(searchable).setFilterable(filterable).setSortable(sortable).setFacetable(facetable);
        if (hasAnalyzerName) {
            searchField.setAnalyzerName(LexicalAnalyzerName.fromString(analyzerName));
        } else if (hasSearchAnalyzerName || hasIndexAnalyzerName) {
            searchField.setAnalyzerName(LexicalAnalyzerName.fromString(searchAnalyzerName));
            searchField.setAnalyzerName(LexicalAnalyzerName.fromString(indexAnalyzerName));
        }
        if (hasNormalizerName) {
            searchField.setNormalizerName(LexicalNormalizerName.fromString(normalizerName));
        }
        if (!CoreUtils.isNullOrEmpty((Object[])synonymMapNames)) {
            List<String> synonymMaps = Arrays.stream(searchableField.synonymMapNames()).filter(synonym -> !synonym.trim().isEmpty()).collect(Collectors.toList());
            searchField.setSynonymMapNames(synonymMaps);
        }
        return searchField;
    }

    private static <T extends Annotation> T getDeclaredAnnotation(Member member, Class<T> annotationType) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(annotationType);
        }
        if (member instanceof Method) {
            return ((Method)member).getAnnotation(annotationType);
        }
        return null;
    }

    private static void validateType(Type type, boolean hasArrayOrCollectionWrapped) {
        if (!(type instanceof ParameterizedType)) {
            if (UNSUPPORTED_TYPES.contains(type)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Type '" + type.getTypeName() + "' is not supported. Please use @FieldIgnore to exclude the field and manually build SearchField to the list if the field is needed. For more information, refer to link: aka.ms/azsdk/java/search/fieldbuilder"));
            }
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (Map.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Map and its subclasses are not supported"));
        }
        if (hasArrayOrCollectionWrapped) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Only single-dimensional array is supported."));
        }
        if (!List.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Collection type '" + type.getTypeName() + "' is not supported"));
        }
    }

    private static SearchFieldDataType covertToSearchFieldDataType(Type type, boolean hasArrayOrCollectionWrapped) {
        FieldBuilder.validateType(type, hasArrayOrCollectionWrapped);
        if (SUPPORTED_NONE_PARAMETERIZED_TYPE.containsKey(type)) {
            return SUPPORTED_NONE_PARAMETERIZED_TYPE.get(type);
        }
        if (FieldBuilder.isArrayOrList(type)) {
            Type componentOrElementType = FieldBuilder.getComponentOrElementType(type);
            return SearchFieldDataType.collection(FieldBuilder.covertToSearchFieldDataType(componentOrElementType, true));
        }
        return SearchFieldDataType.COMPLEX;
    }

    static {
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)Integer.class), SearchFieldDataType.INT32);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put(Integer.TYPE, SearchFieldDataType.INT32);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)Long.class), SearchFieldDataType.INT64);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put(Long.TYPE, SearchFieldDataType.INT64);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)Double.class), SearchFieldDataType.DOUBLE);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put(Double.TYPE, SearchFieldDataType.DOUBLE);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)Boolean.class), SearchFieldDataType.BOOLEAN);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put(Boolean.TYPE, SearchFieldDataType.BOOLEAN);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)String.class), SearchFieldDataType.STRING);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)CharSequence.class), SearchFieldDataType.STRING);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)Character.class), SearchFieldDataType.STRING);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put(Character.TYPE, SearchFieldDataType.STRING);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)Date.class), SearchFieldDataType.DATE_TIME_OFFSET);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)OffsetDateTime.class), SearchFieldDataType.DATE_TIME_OFFSET);
        SUPPORTED_NONE_PARAMETERIZED_TYPE.put((Type)((Object)GeoPoint.class), SearchFieldDataType.GEOGRAPHY_POINT);
        UNSUPPORTED_TYPES.add(Byte.TYPE);
        UNSUPPORTED_TYPES.add((Type)((Object)Byte.class));
        UNSUPPORTED_TYPES.add(Float.TYPE);
        UNSUPPORTED_TYPES.add((Type)((Object)Float.class));
        UNSUPPORTED_TYPES.add(Short.TYPE);
        UNSUPPORTED_TYPES.add((Type)((Object)Short.class));
    }
}

