/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureKeyCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.models.IndexAction;
import com.azure.search.documents.implementation.models.IndexBatch;
import com.azure.search.documents.implementation.util.Constants;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.models.IndexBatchException;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.SearchAudience;
import com.azure.search.documents.models.SuggestOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public final class Utility {
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private static final HttpLogOptions DEFAULT_LOG_OPTIONS = Constants.DEFAULT_LOG_OPTIONS_SUPPLIER.get();
    private static final HttpHeaders HTTP_HEADERS = new HttpHeaders().set("return-client-request-id", "true");
    private static final DecimalFormat COORDINATE_FORMATTER = new DecimalFormat();
    private static final int MULTI_STATUS_CODE = 207;
    private static final String DOCUMENT_NOT_FOUND = "Document not found.";
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final Context STATIC_ENABLE_REST_PROXY_CONTEXT;

    public static HttpPipeline buildHttpPipeline(ClientOptions clientOptions, HttpLogOptions logOptions, Configuration configuration, RetryPolicy retryPolicy, RetryOptions retryOptions, AzureKeyCredential azureKeyCredential, TokenCredential tokenCredential, SearchAudience audience, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, HttpClient httpClient, ClientLogger logger) {
        Configuration buildConfiguration = configuration == null ? Configuration.getGlobalConfiguration() : configuration;
        ClientOptions buildClientOptions = clientOptions == null ? DEFAULT_CLIENT_OPTIONS : clientOptions;
        HttpLogOptions buildLogOptions = logOptions == null ? DEFAULT_LOG_OPTIONS : logOptions;
        String applicationId = CoreUtils.getApplicationId((ClientOptions)buildClientOptions, (HttpLogOptions)buildLogOptions);
        ArrayList<Object> httpPipelinePolicies = new ArrayList<Object>();
        httpPipelinePolicies.add(new AddHeadersPolicy(HTTP_HEADERS));
        httpPipelinePolicies.add(new AddHeadersFromContextPolicy());
        httpPipelinePolicies.add(new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        httpPipelinePolicies.add(new RequestIdPolicy());
        httpPipelinePolicies.addAll(perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(httpPipelinePolicies);
        httpPipelinePolicies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)retryPolicy, (RetryOptions)retryOptions));
        httpPipelinePolicies.add(new AddDatePolicy());
        if (azureKeyCredential != null && tokenCredential != null) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Builder has both AzureKeyCredential and TokenCredential supplied. Only one may be supplied."));
        }
        if (azureKeyCredential != null) {
            httpPipelinePolicies.add(new AzureKeyCredentialPolicy("api-key", azureKeyCredential));
        } else if (tokenCredential != null) {
            String audienceUrl = audience == null ? SearchAudience.AZURE_PUBLIC_CLOUD.toString() : audience.toString();
            httpPipelinePolicies.add(new BearerTokenAuthenticationPolicy(tokenCredential, new String[]{audienceUrl + "/.default"}));
        } else {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Builder doesn't have a credential configured. Supply either an AzureKeyCredential or TokenCredential."));
        }
        httpPipelinePolicies.addAll(perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(httpPipelinePolicies);
        HttpHeaders headers = new HttpHeaders();
        buildClientOptions.getHeaders().forEach(header -> headers.set(header.getName(), header.getValue()));
        if (headers.getSize() > 0) {
            httpPipelinePolicies.add(new AddHeadersPolicy(headers));
        }
        httpPipelinePolicies.add(new HttpLoggingPolicy(buildLogOptions));
        return new HttpPipelineBuilder().clientOptions(buildClientOptions).httpClient(httpClient).policies(httpPipelinePolicies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public static Mono<Response<IndexDocumentsResult>> indexDocumentsWithResponseAsync(SearchIndexClientImpl restClient, List<IndexAction> actions, boolean throwOnAnyError, Context context, ClientLogger logger) {
        try {
            return restClient.getDocuments().indexWithResponseAsync(new IndexBatch(actions), null, context).onErrorMap(MappingUtils::exceptionMapper).flatMap(response -> response.getStatusCode() == 207 && throwOnAnyError ? Mono.error((Throwable)((Object)new IndexBatchException((IndexDocumentsResult)response.getValue()))) : Mono.just((Object)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)logger, (RuntimeException)ex);
        }
    }

    public static Response<IndexDocumentsResult> indexDocumentsWithResponse(SearchIndexClientImpl restClient, List<IndexAction> actions, boolean throwOnAnyError, Context context, ClientLogger logger) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Response<IndexDocumentsResult> response = restClient.getDocuments().indexWithResponse(new IndexBatch(actions), null, Utility.enableSyncRestProxy(context));
            if (response.getStatusCode() == 207 && throwOnAnyError) {
                throw new IndexBatchException((IndexDocumentsResult)response.getValue());
            }
            return response;
        });
    }

    public static SearchIndexClientImpl buildRestClient(SearchServiceVersion serviceVersion, String endpoint, String indexName, HttpPipeline httpPipeline) {
        return new SearchIndexClientImpl(httpPipeline, endpoint, indexName, serviceVersion.getVersion());
    }

    public static synchronized String formatCoordinate(double coordinate) {
        return COORDINATE_FORMATTER.format(coordinate);
    }

    public static String readSynonymsFromFile(Path filePath) {
        try {
            return new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public static <T> T executeRestCallWithExceptionHandling(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (SearchErrorException exception) {
            throw new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        catch (com.azure.search.documents.implementation.models.SearchErrorException exception) {
            throw new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    public static Context enableSyncRestProxy(Context context) {
        if (context == null || context == Context.NONE) {
            return STATIC_ENABLE_REST_PROXY_CONTEXT;
        }
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    public static SuggestOptions ensureSuggestOptions(SuggestOptions suggestOptions) {
        if (suggestOptions == null) {
            return null;
        }
        return CoreUtils.isNullOrEmpty(suggestOptions.getSelect()) ? suggestOptions.setSelect("*") : suggestOptions;
    }

    public static Throwable exceptionMapper(Throwable throwable) {
        if (!(throwable instanceof com.azure.search.documents.implementation.models.SearchErrorException)) {
            return throwable;
        }
        return Utility.mapSearchErrorException((com.azure.search.documents.implementation.models.SearchErrorException)((Object)throwable));
    }

    public static HttpResponseException mapSearchErrorException(com.azure.search.documents.implementation.models.SearchErrorException exception) {
        if (exception.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(DOCUMENT_NOT_FOUND, exception.getResponse());
        }
        return new HttpResponseException(exception.getMessage(), exception.getResponse());
    }

    private Utility() {
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-search-documents.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        STATIC_ENABLE_REST_PROXY_CONTEXT = Context.NONE.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }
}

