/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.SearchIndexerClientBuilder;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.DocumentKeysOrIds;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.ListSkillsetsResult;
import com.azure.search.documents.indexes.implementation.models.SkillNames;
import com.azure.search.documents.indexes.models.CreateOrUpdateDataSourceConnectionOptions;
import com.azure.search.documents.indexes.models.CreateOrUpdateIndexerOptions;
import com.azure.search.documents.indexes.models.CreateOrUpdateSkillsetOptions;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;
import java.util.List;
import java.util.Objects;

@ServiceClient(builder=SearchIndexerClientBuilder.class)
public class SearchIndexerClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchIndexerClient.class);
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final SearchServiceClientImpl restClient;
    private final HttpPipeline httpPipeline;

    SearchIndexerClient(String endpoint, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline) {
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.restClient = new SearchServiceClientImpl(httpPipeline, endpoint, serviceVersion.getVersion());
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection createOrUpdateDataSourceConnection(SearchIndexerDataSourceConnection dataSourceConnection) {
        return (SearchIndexerDataSourceConnection)this.createOrUpdateDataSourceConnectionWithResponse(dataSourceConnection, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createOrUpdateDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, boolean onlyIfUnchanged, Context context) {
        return this.createOrUpdateDataSourceConnectionWithResponse(dataSourceConnection, onlyIfUnchanged, null, context);
    }

    Response<SearchIndexerDataSourceConnection> createOrUpdateDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSource, boolean onlyIfUnchanged, Boolean ignoreResetRequirements, Context context) {
        String ifMatch;
        if (dataSource == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'dataSource' cannot be null."));
        }
        String string = ifMatch = onlyIfUnchanged ? dataSource.getETag() : null;
        if (dataSource.getConnectionString() == null) {
            dataSource.setConnectionString("<unchanged>");
        }
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getDataSources().createOrUpdateWithResponse(dataSource.getName(), dataSource, ifMatch, null, ignoreResetRequirements, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createOrUpdateDataSourceConnectionWithResponse(CreateOrUpdateDataSourceConnectionOptions options, Context context) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return this.createOrUpdateDataSourceConnectionWithResponse(options.getDataSourceConnection(), options.isOnlyIfUnchanged(), options.isCacheResetRequirementsIgnored(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection createDataSourceConnection(SearchIndexerDataSourceConnection dataSourceConnection) {
        return (SearchIndexerDataSourceConnection)this.createDataSourceConnectionWithResponse(dataSourceConnection, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> createDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getDataSources().createWithResponse(dataSourceConnection, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerDataSourceConnection getDataSourceConnection(String dataSourceConnectionName) {
        return (SearchIndexerDataSourceConnection)this.getDataSourceConnectionWithResponse(dataSourceConnectionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerDataSourceConnection> getDataSourceConnectionWithResponse(String dataSourceConnectionName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getDataSources().getWithResponse(dataSourceConnectionName, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerDataSourceConnection> listDataSourceConnections() {
        return this.listDataSourceConnections(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerDataSourceConnection> listDataSourceConnections(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mappingPagingDataSource(this.listDataSourceConnectionsWithResponse(null, context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    private Response<ListDataSourcesResult> listDataSourceConnectionsWithResponse(String select, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getDataSources().listWithResponse(select, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listDataSourceConnectionNames() {
        return this.listDataSourceConnectionNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listDataSourceConnectionNames(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mappingPagingDataSourceNames(this.listDataSourceConnectionsWithResponse("name", context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataSourceConnection(String dataSourceConnectionName) {
        this.deleteDataSourceConnectionWithResponse(new SearchIndexerDataSourceConnection(dataSourceConnectionName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataSourceConnectionWithResponse(SearchIndexerDataSourceConnection dataSourceConnection, boolean onlyIfUnchanged, Context context) {
        String eTag = onlyIfUnchanged ? dataSourceConnection.getETag() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getDataSources().deleteWithResponse(dataSourceConnection.getName(), eTag, null, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer createIndexer(SearchIndexer indexer) {
        return (SearchIndexer)this.createIndexerWithResponse(indexer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createIndexerWithResponse(SearchIndexer indexer, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().createWithResponse(indexer, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer createOrUpdateIndexer(SearchIndexer indexer) {
        return (SearchIndexer)this.createOrUpdateIndexerWithResponse(indexer, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createOrUpdateIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        return this.createOrUpdateIndexerWithResponse(indexer, onlyIfUnchanged, null, null, context);
    }

    Response<SearchIndexer> createOrUpdateIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Boolean disableCacheReprocessingChangeDetection, Boolean ignoreResetRequirements, Context context) {
        if (indexer == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'indexer' cannot be null."));
        }
        String ifMatch = onlyIfUnchanged ? indexer.getETag() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().createOrUpdateWithResponse(indexer.getName(), indexer, ifMatch, null, disableCacheReprocessingChangeDetection, ignoreResetRequirements, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createOrUpdateIndexerWithResponse(CreateOrUpdateIndexerOptions options, Context context) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return this.createOrUpdateIndexerWithResponse(options.getIndexer(), options.isOnlyIfUnchanged(), options.isCacheReprocessingChangeDetectionDisabled(), options.isCacheResetRequirementsIgnored(), context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexer> listIndexers() {
        return this.listIndexers(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexer> listIndexers(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mappingPagingSearchIndexer(this.listIndexersWithResponse(null, context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    private Response<ListIndexersResult> listIndexersWithResponse(String select, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().listWithResponse(select, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexerNames() {
        return this.listIndexerNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexerNames(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mappingPagingSearchIndexerNames(this.listIndexersWithResponse("name", context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer getIndexer(String indexerName) {
        return (SearchIndexer)this.getIndexerWithResponse(indexerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> getIndexerWithResponse(String indexerName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().getWithResponse(indexerName, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteIndexer(String indexerName) {
        this.deleteIndexerWithResponse(new SearchIndexer(indexerName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteIndexerWithResponse(SearchIndexer indexer, boolean onlyIfUnchanged, Context context) {
        String eTag = onlyIfUnchanged ? indexer.getETag() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().deleteWithResponse(indexer.getName(), eTag, null, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetIndexer(String indexerName) {
        this.resetIndexerWithResponse(indexerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetIndexerWithResponse(String indexerName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().resetWithResponse(indexerName, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void runIndexer(String indexerName) {
        this.runIndexerWithResponse(indexerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> runIndexerWithResponse(String indexerName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().runWithResponse(indexerName, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerStatus getIndexerStatus(String indexerName) {
        return (SearchIndexerStatus)this.getIndexerStatusWithResponse(indexerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerStatus> getIndexerStatusWithResponse(String indexerName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexers().getStatusWithResponse(indexerName, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetDocuments(String indexerName, Boolean overwrite, List<String> documentKeys, List<String> datasourceDocumentIds) {
        this.resetDocumentsWithResponse(new SearchIndexer(indexerName), overwrite, documentKeys, datasourceDocumentIds, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetDocumentsWithResponse(SearchIndexer indexer, Boolean overwrite, List<String> documentKeys, List<String> datasourceDocumentIds, Context context) {
        try {
            DocumentKeysOrIds documentKeysOrIds = new DocumentKeysOrIds().setDocumentKeys(documentKeys).setDatasourceDocumentIds(datasourceDocumentIds);
            return this.restClient.getIndexers().resetDocsWithResponse(indexer.getName(), overwrite, documentKeysOrIds, null, Utility.enableSyncRestProxy(context));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset createSkillset(SearchIndexerSkillset skillset) {
        return (SearchIndexerSkillset)this.createSkillsetWithResponse(skillset, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createSkillsetWithResponse(SearchIndexerSkillset skillset, Context context) {
        if (skillset == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'skillset' cannot be null."));
        }
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSkillsets().createWithResponse(skillset, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset getSkillset(String skillsetName) {
        return (SearchIndexerSkillset)this.getSkillsetWithResponse(skillsetName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> getSkillsetWithResponse(String skillsetName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSkillsets().getWithResponse(skillsetName, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerSkillset> listSkillsets() {
        return this.listSkillsets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndexerSkillset> listSkillsets(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mappingPagingSkillset(this.listSkillsetsWithResponse(null, context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    private Response<ListSkillsetsResult> listSkillsetsWithResponse(String select, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSkillsets().listWithResponse(select, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSkillsetNames() {
        return this.listSkillsetNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSkillsetNames(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mappingPagingSkillsetNames(this.listSkillsetsWithResponse("name", context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerSkillset createOrUpdateSkillset(SearchIndexerSkillset skillset) {
        return (SearchIndexerSkillset)this.createOrUpdateSkillsetWithResponse(skillset, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createOrUpdateSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        return this.createOrUpdateSkillsetWithResponse(skillset, onlyIfUnchanged, null, null, context);
    }

    Response<SearchIndexerSkillset> createOrUpdateSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Boolean disableCacheReprocessingChangeDetection, Boolean ignoreResetRequirements, Context context) {
        if (skillset == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'skillset' cannot be null."));
        }
        String ifMatch = onlyIfUnchanged ? skillset.getETag() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSkillsets().createOrUpdateWithResponse(skillset.getName(), skillset, ifMatch, null, disableCacheReprocessingChangeDetection, ignoreResetRequirements, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerSkillset> createOrUpdateSkillsetWithResponse(CreateOrUpdateSkillsetOptions options, Context context) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return this.createOrUpdateSkillsetWithResponse(options.getSkillset(), options.isOnlyIfUnchanged(), options.isCacheReprocessingChangeDetectionDisabled(), options.isCacheResetRequirementsIgnored(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSkillset(String skillsetName) {
        this.deleteSkillsetWithResponse(new SearchIndexerSkillset(skillsetName), false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSkillsetWithResponse(SearchIndexerSkillset skillset, boolean onlyIfUnchanged, Context context) {
        String eTag = onlyIfUnchanged ? skillset.getETag() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSkillsets().deleteWithResponse(skillset.getName(), eTag, null, null, Utility.enableSyncRestProxy(context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetSkills(String skillsetName, List<String> skillNames) {
        this.resetSkillsWithResponse(new SearchIndexerSkillset(skillsetName), skillNames, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetSkillsWithResponse(SearchIndexerSkillset skillset, List<String> skillNames, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSkillsets().resetSkillsWithResponse(skillset.getName(), new SkillNames().setSkillNames(skillNames), null, Utility.enableSyncRestProxy(context)));
    }
}

