/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.EntityCategory;
import com.azure.search.documents.indexes.models.EntityRecognitionSkillLanguage;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class EntityRecognitionSkillV1
extends SearchIndexerSkill {
    private static final String ODATA_TYPE = "#Microsoft.Skills.Text.EntityRecognitionSkill";
    private List<EntityCategory> categories;
    private EntityRecognitionSkillLanguage defaultLanguageCode;
    private Boolean includeTypelessEntities;
    private Double minimumPrecision;

    public EntityRecognitionSkillV1(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public List<EntityCategory> getCategories() {
        return this.categories;
    }

    public EntityRecognitionSkillV1 setCategories(List<EntityCategory> categories) {
        this.categories = categories;
        return this;
    }

    public EntityRecognitionSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public EntityRecognitionSkillV1 setDefaultLanguageCode(EntityRecognitionSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Boolean isIncludeTypelessEntities() {
        return this.includeTypelessEntities;
    }

    public EntityRecognitionSkillV1 setIncludeTypelessEntities(Boolean includeTypelessEntities) {
        this.includeTypelessEntities = includeTypelessEntities;
        return this;
    }

    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    public EntityRecognitionSkillV1 setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    @Override
    public EntityRecognitionSkillV1 setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public EntityRecognitionSkillV1 setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public EntityRecognitionSkillV1 setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", ODATA_TYPE);
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeStringField("defaultLanguageCode", Objects.toString((Object)this.defaultLanguageCode, null));
        jsonWriter.writeBooleanField("includeTypelessEntities", this.includeTypelessEntities);
        jsonWriter.writeNumberField("minimumPrecision", (Number)this.minimumPrecision);
        return jsonWriter.writeEndObject();
    }

    public static EntityRecognitionSkillV1 fromJson(JsonReader jsonReader) throws IOException {
        return (EntityRecognitionSkillV1)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            List categories = null;
            EntityRecognitionSkillLanguage defaultLanguageCode = null;
            Boolean includeTypelessEntities = null;
            Double minimumPrecision = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if (ODATA_TYPE.equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.EntityRecognitionSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    categories = reader.readArray(reader1 -> EntityCategory.fromString(reader1.getString()));
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = EntityRecognitionSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("includeTypelessEntities".equals(fieldName)) {
                    includeTypelessEntities = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minimumPrecision".equals(fieldName)) {
                    minimumPrecision = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                EntityRecognitionSkillV1 deserializedEntityRecognitionSkillV1 = new EntityRecognitionSkillV1(inputs, outputs);
                deserializedEntityRecognitionSkillV1.setName(name);
                deserializedEntityRecognitionSkillV1.setDescription(description);
                deserializedEntityRecognitionSkillV1.setContext(context);
                deserializedEntityRecognitionSkillV1.categories = categories;
                deserializedEntityRecognitionSkillV1.defaultLanguageCode = defaultLanguageCode;
                deserializedEntityRecognitionSkillV1.includeTypelessEntities = includeTypelessEntities;
                deserializedEntityRecognitionSkillV1.minimumPrecision = minimumPrecision;
                return deserializedEntityRecognitionSkillV1;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

